package cn.com.duiba.tuia.media.service;

import cn.com.duiba.tuia.media.api.dto.MaterialCtrDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2017/2/8
 */
public interface MaterialCtrService {

    /**
     * 获取某个广告位下的素材列表，根据CTR排序
     * 
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param activityType 活动TYPE
     * @return 素材CTR排序列表
     */
    List<MaterialCtrDto> getMaterialCtrBySlotActivity(Long slotId, Long activityId, Integer activityType) throws TuiaMediaException;
    
    /**
     * 获取某个广告位下的素材列表(根据活动来源)，根据CTR排序
     * 
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param source 活动来源
     * @return 素材CTR排序列表
     */
    List<MaterialCtrDto> getMaterialCtrBySlotActivityAndSource(Long slotId, Long activityId, Integer source) throws TuiaMediaException;
}
