package cn.com.duiba.tuia.media.service;

import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.media.api.dto.req.ReqMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationDO;

/**
 * @author xuyenan
 * @createTime 2016/12/20
 */
public interface MaterialSpecificationService {

    /**
     * 根据条件查询规格列表(以update时间从新往后排序)
     *
     * @param req 条件
     * @return 规格列表
     */
    List<RspMaterialSpecificationDto> getMaterialSpecificationList(ReqMaterialSpecificationDto req)
                                                                                                   throws TuiaMediaException;

    /**
     * 根据条件查询时的总数量
     *
     * @param req 条件
     * @return 数量
     */
    int getMaterialSpecificationAmount(ReqMaterialSpecificationDto req) throws TuiaMediaException;

    /**
     * 删除规格
     * 
     * @param msId 规格ID
     * @return Boolean
     */
    Boolean deleteMaterialSpecification(Long msId) throws TuiaMediaException;

    /**
     * 添加/更新接口，需要处理规格和素材列表
     * 
     * @param req
     * @return Boolean
     */
    Boolean addMaterialSpecification(ReqMaterialSpecificationDto req) throws TuiaMediaException;

    /**
     * 获取规格明细
     * 
     * @param msId 规格ID
     * @return 规格明细
     */
    RspMaterialSpecificationDto getMaterialSpecificationDetail(Long msId) throws TuiaMediaException;

    /**
     * 查询规格名称
     *
     * @param ids 规格ID列表
     * @return 规格名称MAP
     */
    Map<Long, String> getMsNameByIds(List<Long> ids) throws TuiaMediaException;

    /**
     * 根据ID列表获取MAP
     * 
     * @param ids 规格ID列表
     * @return 规格MAP
     */
    Map<Long, MaterialSpecificationDO> getMapByIds(List<Long> ids) throws TuiaMediaException;

    /**
     * 新素材曝光量达2000后更改状态
     *
     * @param materialId 素材ID
     * @return Boolean
     */
    Boolean changeMsItemContentStatus(Long materialId) throws TuiaMediaException;

    /**
     * getMsImageUrl:(通过素材IDs查询图片地址). <br/>
     *
     * @param ids
     * @return
     * @since JDK 1.6
     */
    Map<Long, String> getMsImageUrl(List<Long> ids) throws TuiaMediaException;
    
    /**
     * 
     * getMsIdByName:(通过广告位规格名称查询广告位规格ID). <br/>
     *
     * @param msName
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    List<Long> getMsIdByName(String msName)throws TuiaMediaException;

}
