package cn.com.duiba.tuia.media.service;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

import java.util.List;

/**
 * @author xuyenan
 * @createTime 2016/12/23
 */
public interface MediaAppActivityService {

    /**
     * 活动定向到媒体
     *
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @param directStatus 状态
     * @param appIds 媒体ID列表
     * @return Boolean
     */
    Boolean activityDirectToMediaApp(Long activityId, Integer activityType, Integer directStatus, List<Long> appIds) throws TuiaMediaException;

    /**
     * 活动定向到媒体
     *
     * @param activityId 活动ID
     * @param source 活动类型
     * @param directStatus 状态
     * @param appIds 媒体ID列表
     * @return Boolean
     */
    Boolean activityDirectToMediaAppBySource(Long activityId, Integer activityType, Integer source, Integer directStatus, List<Long> appIds) throws TuiaMediaException;
}
