/**
 * Project Name:media-biz File Name:MediaService.java Package Name:cn.com.duiba.tuia.media.service
 * Date:2016年9月26日上午11:27:24 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.media.service;

import java.util.List;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqCreatMediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppStatusDto;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqPageQueryMediaApp;
import cn.com.duiba.tuia.media.model.req.ReqUpdateMediaApp;
import cn.com.duiba.tuia.media.model.rsp.RspIdAndValue;
import cn.com.duiba.tuia.media.model.rsp.RspMediaApp;

/**
 * ClassName:MediaAppService <br/>
 * Function: 媒体业务接口 FUNCTION. <br/>
 * Date: 2016年9月26日 上午11:27:24 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */

public interface MediaAppService {

    /**
     * 创建媒体信息.
     *
     * @param param the param
     * @return true, if creates the media app
     * @throws TuiaMediaException the tuia media exception
     */
    Boolean createMediaApp(ReqCreatMediaAppDto param) throws TuiaMediaException;

    /**
     * 获取媒体信息列表.
     *
     * @param mediaAppQuery the media app query
     * @return the media app list
     * @throws TuiaMediaException the tuia media exception
     */

    PageResultDto<RspMediaApp> getMediaAppList(ReqPageQueryMediaApp mediaAppQuery) throws TuiaMediaException;

    /**
     * updateMediaApp:(修改媒体信息). <br/>
     *
     * @param param the param
     * @return true, if update media app
     * @throws TuiaMediaException the tuia media exception
     * @author ZFZ
     * @since JDK 1.6
     */
    Boolean updateMediaApp(ReqUpdateMediaApp param) throws TuiaMediaException;

    /**
     * 获取媒体信息.
     *
     * @param appId the app id
     * @return the media app dto
     * @throws TuiaMediaException the tuia media exception
     */
    MediaAppDto getMediaAppDto(Long appId) throws TuiaMediaException;

    /**
     * updateMediaAppStatus:(修改媒体信息状态). <br/>
     *
     * @param param the param
     * @return true, if update media app status
     * @throws TuiaMediaException the tuia media exception
     * @author ZFZ
     * @since JDK 1.6
     */
    Boolean updateMediaAppStatus(ReqUpdateMediaAppStatusDto param) throws TuiaMediaException;

    /**
     * 通过媒体名称模糊查询appId列表.
     *
     * @param appName the app name
     * @return the list< long>
     * @throws TuiaMediaException the tuia media exception
     */
    List<Long> selectIdsByName(String appName) throws TuiaMediaException;

    /**
     * 通过appIds集合批量查询.
     *
     * @param appIds the app ids
     * @return the list< id and name>
     * @throws TuiaMediaException the tuia media exception
     */
    List<IdAndName> selectAppIdAndName(List<Long> appIds) throws TuiaMediaException;

    /**
     * selectAppIdAndNameByMediaId:(通过媒体用户Id获取所有媒体appId和appName). <br/>
     *
     * @param mediaId the media id
     * @return the list< rsp id and value>
     * @throws TuiaMediaException the tuia media exception
     * @author ZFZ
     * @since JDK 1.6
     */
    List<RspIdAndValue> selectAppIdAndNameByMediaId(Long mediaId) throws TuiaMediaException;

    /**
     * 获取所有媒体应用ID和名称.
     *
     * @return true, if select all app id and name
     * @throws TuiaMediaException the tuia media exception
     */
    boolean selectAllAppIdAndName() throws TuiaMediaException;

    /**
     * 删除所有媒体应用ID和名称.
     *
     * @return true, if del all app id and name
     * @throws TuiaMediaException the tuia media exception
     */
    boolean delAllAppIdAndName() throws TuiaMediaException;
    
    /**
     * 通过媒体ID查询媒体名称.
     *
     * @param appId the app id
     * @return String
     * @throws TuiaMediaException the tuia media exception
     */
    String selectAppNameById(Long appId)throws TuiaMediaException;
}
