package cn.com.duiba.tuia.media.service.cacheservice;

import cn.com.duiba.tuia.media.api.constant.CacheKey;
import cn.com.duiba.tuia.media.api.constant.SplitConstant;
import cn.com.duiba.tuia.media.api.utils.CacheKeyUtils;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.utils.JsonUtils;
import cn.com.duiba.wolf.redis.RedisClient;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * @author xuyenan
 * @createTime 2016/12/23
 */
@Service
public class ActivityCacheService {

    @Autowired
    private RedisClient redisClient;

    private Logger      logger = LoggerFactory.getLogger(ActivityCacheService.class);

    /**
     * 从缓存获取活动，key=id+type
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return 活动
     */
    public ActivityDto get(Long activityId, Integer activityType) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivityByKey(activityId + SplitConstant.SPLIT_HYPHEN + activityType);
        String value = redisClient.get(key);
        if (StringUtils.isEmpty(value)) {
            return null;
        }

        try {
            return JsonUtils.jsonToObject(ActivityDto.class, value);
        } catch (Exception e) {
            logger.info(" CacheKeyUtils.getActivityByKey JsonUtils.jsonToObject error", e);
            return null;
        }
    }
    
    /**
     * 从缓存获取活动，key=id+type
     * 
     * @param activityId 活动ID
     * @param source 活动来源
     * @return 活动
     */
    public ActivityDto getBySource(Long activityId, Integer source) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivityByKey(CacheKey.ACTIVITY_SOURCE_KEY + activityId
                                                    + SplitConstant.SPLIT_HYPHEN + source);
        String value = redisClient.get(key);
        if (StringUtils.isEmpty(value)) {
            return null;
        }

        try {
            return JsonUtils.jsonToObject(ActivityDto.class, value);
        } catch (Exception e) {
            logger.info(" CacheKeyUtils.getActivityByKey JsonUtils.jsonToObject error", e);
            return null;
        }
    }

    /**
     * 活动写入缓存
     * 
     * @param activityDto 活动
     */
    public void set(ActivityDto activityDto) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivityByKey(activityDto.getActivityId() + SplitConstant.SPLIT_HYPHEN + activityDto.getActivityType());
        String value = JsonUtils.objectToString(activityDto);
        redisClient.set(key, value);
    }
    
    /**
     * 活动写入缓存
     * 
     * @param activityDto 活动
     */
    public void setBySource(ActivityDto activityDto) throws TuiaMediaException {
        String key = CacheKeyUtils.getActivityByKey(CacheKey.ACTIVITY_SOURCE_KEY + activityDto.getActivityId()
                                                    + SplitConstant.SPLIT_HYPHEN + activityDto.getSource());
        String value = JsonUtils.objectToString(activityDto);
        redisClient.set(key, value);
    }
}
