/**
 * Project Name:media-biz<br>
 * File Name:AccountBankServiceImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.service.impl<br>
 * Date:2016年9月30日下午4:03:31<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.AccountBankDAO;
import cn.com.duiba.tuia.media.domain.AccountBankDto;
import cn.com.duiba.tuia.media.service.AccountBankService;

/**
 * ClassName: AccountBankServiceImpl <br/>
 * date: 2016年9月30日 下午4:03:31 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@Service
public class AccountBankServiceImpl implements AccountBankService {

    @Autowired
    private AccountBankDAO accountBankDAO;

    @Override
    public boolean insertAccountBank(AccountBankDto accountBankDto) throws TuiaMediaException {
        return accountBankDAO.insert(accountBankDto) == 1 ? true : false;
    }

    @Override
    public AccountBankDto selectByMediaId(Long mediaId) throws TuiaMediaException {
        return accountBankDAO.selectById(mediaId);

    }

}
