package cn.com.duiba.tuia.media.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityManualPlanDAO;
import cn.com.duiba.tuia.media.dataobject.ActivityManualPlanDO;
import cn.com.duiba.tuia.media.service.ActivityManualService;

/**
 * ActivityManualServiceImpl
 */
@Service
public class ActivityManualServiceImpl implements ActivityManualService {

    @Autowired
    private ActivityManualPlanDAO activityManualPlanDAO;

    @Override
    public boolean addActivityManualPlan(ActivityManualPlanDO manualPlan) throws TuiaMediaException {
        List<ActivityManualPlanDO> planList = this.activityManualPlanDAO.selectForList(manualPlan.getSlotId());
        for (ActivityManualPlanDO plan : planList) {
            if (plan.getActivityId() != null && plan.getSource() != null && plan.getActivityId().equals(manualPlan.getActivityId())
                    && plan.getSource().equals(manualPlan.getSource())) {
                throw new TuiaMediaException(ErrorCode.E9999999.getErrorCode(), "活动已存在");
            }
        }
        manualPlan.setStatus(ActivityManualPlanDO.STATUS_PREVIEW);
        return this.activityManualPlanDAO.insert(manualPlan);
    }

    @Override
    public boolean modifyActivityManualPlan(ActivityManualPlanDO manualPlan) throws TuiaMediaException {
        return this.activityManualPlanDAO.update(manualPlan);
    }

    @Override
    public ActivityManualPlanDO findActivityManualPlan(Long slotId) throws TuiaMediaException {
        List<ActivityManualPlanDO> planList = findActivityManualPlans(slotId);
        for (ActivityManualPlanDO plan : planList) {
            if (ActivityManualPlanDO.STATUS_RELEASE == plan.getStatus()) {
                return plan;
            }
        }
        return null;
    }

    @Override
    public List<ActivityManualPlanDO> findActivityManualPlans(Long slotId) throws TuiaMediaException {
        ActivityManualPlanDO currentPlan = null;
        long currentTime = System.currentTimeMillis();
        List<ActivityManualPlanDO> planList = this.activityManualPlanDAO.selectForList(slotId);
        for (ActivityManualPlanDO plan : planList) {
            if (currentTime >= plan.getReleaseTime().getTime()) {
                currentPlan = plan;
            }
        }

        // 活动达到生效时间，原生效活动改成过期，新活动改成生效
        if (currentPlan != null) {
            currentPlan.setStatus(ActivityManualPlanDO.STATUS_RELEASE);
            this.activityManualPlanDAO.updateStatus(currentPlan, ActivityManualPlanDO.STATUS_RELEASE);
            this.activityManualPlanDAO.updateStatusBefore(currentPlan, ActivityManualPlanDO.STATUS_EXPIRED);
        }
        return this.activityManualPlanDAO.selectForList(slotId);
    }

    @Override
    public boolean removeActivityManualPlan(ActivityManualPlanDO manualPlan) throws TuiaMediaException {
        return this.activityManualPlanDAO.delete(manualPlan);
    }

    @Override
    public List<Long> findActivityManualPlanSlots(Long activityId, Integer activityType) throws TuiaMediaException {
        return this.activityManualPlanDAO.selectSlotForList(activityId, activityType);
    }

    @Override
    public List<Long> findActivityManualPlanSlotsBySource(Long activityId, Integer source) throws TuiaMediaException {
        return this.activityManualPlanDAO.selectSlotForListBySource(activityId, source);
    }
}
