package cn.com.duiba.tuia.media.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import cn.com.duiba.tuia.media.api.constant.MaterialSpecificationConstant;
import cn.com.duiba.tuia.media.api.dto.ActivitySpmDto;
import cn.com.duiba.tuia.media.api.dto.SlotCacheDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivitySpmDAO;
import cn.com.duiba.tuia.media.dataobject.ActivitySpmDO;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySpmService;

/**
 * @author xuyenan
 * @createTime 2017/2/8
 */
@Service("activitySpmService")
public class ActivitySpmServiceImpl implements ActivitySpmService {

    @Autowired
    private ActivitySpmDAO   activitySpmDAO;

    @Autowired
    private SlotCacheService slotCacheService;

    @Autowired
    private ActivityService  activityService;

    @Override
    public List<ActivitySpmDto> getSlotSpm(Long slotId, Integer statType) throws TuiaMediaException {
        if (MaterialSpecificationConstant.STAT_TYPE_SLOT == statType) {
            SlotCacheDto slotCacheDto = slotCacheService.getSlot(slotId);
            Long appId = slotCacheDto.getAppId();
            List<ActivitySpmDO> spm = activitySpmDAO.selectBySlot(slotId, appId, MaterialSpecificationConstant.STAT_TYPE_SLOT);
            if (!CollectionUtils.isEmpty(spm)) {
                return parseToDto(spm);
            }
        } else if (MaterialSpecificationConstant.STAT_TYPE_APP == statType) {
            // 此处的slotId传的是AppId
            List<ActivitySpmDO> spm = activitySpmDAO.selectBySlot(-1L, slotId, MaterialSpecificationConstant.STAT_TYPE_APP);
            if (!CollectionUtils.isEmpty(spm)) {
                return parseToDto(spm);
            }
        } else {
            List<ActivitySpmDO> spm = activitySpmDAO.selectBySlot(-1L, -1L, MaterialSpecificationConstant.STAT_TYPE_OVERALL);
            if (!CollectionUtils.isEmpty(spm)) {
                return parseToDto(spm);
            }
        }
        return Collections.emptyList();
    }

    private List<ActivitySpmDto> parseToDto(List<ActivitySpmDO> list) {
        List<ActivitySpmDto> result = new ArrayList<>();
        for (ActivitySpmDO activitySpmDO : list) {
            ActivitySpmDto activitySpmDto = new ActivitySpmDto();
            activitySpmDto.setActivityId(activitySpmDO.getActivityId());
            activitySpmDto.setActivityType(activitySpmDO.getActivityType());
            activitySpmDto.setSpm(activitySpmDO.getSpm());
            activitySpmDto.setStatType(activitySpmDO.getStatType());
            activitySpmDto.setSource(activitySpmDO.getSource());
            result.add(activitySpmDto);
        }
        return result;
    }

    private Map<Long, Integer> getActivitySpm(List<Long> activityIds, Integer statType) throws TuiaMediaException {
        Map<Long, Integer> spmMap = new HashMap<>();
        List<ActivitySpmDO> spmList = activitySpmDAO.selectByActivityOverall(activityIds);
        for (ActivitySpmDO spm : spmList) {
            spmMap.put(spm.getActivityId(), spm.getSpm() != null ? spm.getSpm().intValue() : 0);
        }
        return spmMap;
    }

    @Override
    public List<Long> getTuiaActivityIdList(int count) throws TuiaMediaException {
        List<Long> activityIds = activityService.getActivityBySource(ReqIdAndType.REQ_ACT_SOURCE_TUIA, count);
        if (CollectionUtils.isEmpty(activityIds)) {
            return Collections.emptyList();
        }

        final Map<Long, Integer> spmMap = getActivitySpm(activityIds, MaterialSpecificationConstant.STAT_TYPE_OVERALL);
        Collections.sort(activityIds, new Comparator<Long>() {
            @Override
            public int compare(Long o1, Long o2) {
                Integer spm1 = spmMap.get(o1);
                Integer spm2 = spmMap.get(o2);
                if (spm1 == null || spm2 == null) {
                    if (spm1 != null) {
                        return -1;
                    } else if (spm2 != null) {
                        return 1;
                    } else {
                        return 0;
                    }
                } else {
                    return spm2 - spm1;
                }
            }
        });
        return activityIds;
    }
}
