package cn.com.duiba.tuia.media.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import cn.com.duiba.tuia.media.api.dto.MaterialCtrDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.MaterialCtrDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialCtrDO;
import cn.com.duiba.tuia.media.service.MaterialCtrService;

/**
 * @author xuyenan
 * @createTime 2017/2/8
 */
@Service("materialCtrService")
public class MaterialCtrServiceImpl implements MaterialCtrService {

    @Autowired
    private MaterialCtrDAO materialCtrDAO;

    @Override
    public List<MaterialCtrDto> getMaterialCtrBySlotActivity(Long slotId, Long activityId, Integer activityType) throws TuiaMediaException {
        List<MaterialCtrDO> materialCtrList = materialCtrDAO.selectBySlotActivity(slotId, activityId, activityType);
        if (CollectionUtils.isEmpty(materialCtrList)) {
            return Collections.emptyList();
        }
        List<MaterialCtrDto> result = new ArrayList<>();
        for (MaterialCtrDO materialCtrDO : materialCtrList) {
            MaterialCtrDto rspActivityDto = new MaterialCtrDto();
            BeanUtils.copyProperties(materialCtrDO, rspActivityDto);
            result.add(rspActivityDto);
        }
        return result;
    }

    @Override
    public List<MaterialCtrDto> getMaterialCtrBySlotActivityAndSource(Long slotId, Long activityId, Integer source)
                                                                                                                   throws TuiaMediaException {
        List<MaterialCtrDO> materialCtrList = materialCtrDAO.selectBySlotActivityAndSource(slotId, activityId, source);
        if (CollectionUtils.isEmpty(materialCtrList)) {
            return Collections.emptyList();
        }
        List<MaterialCtrDto> result = new ArrayList<>();
        for (MaterialCtrDO materialCtrDO : materialCtrList) {
            MaterialCtrDto rspActivityDto = new MaterialCtrDto();
            BeanUtils.copyProperties(materialCtrDO, rspActivityDto);
            result.add(rspActivityDto);
        }
        return result;
    }
}
