package cn.com.duiba.tuia.media.service.impl;

import java.util.ArrayList;
import java.util.List;

import cn.com.duiba.tuia.media.service.cacheservice.ActivityDirectAppCacheService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import cn.com.duiba.tuia.media.api.constant.ActivityConstant;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dao.MediaAppActivityDAO;
import cn.com.duiba.tuia.media.dataobject.MediaAppActivityDO;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.service.MediaAppActivityService;

/**
 * @author xuyenan
 * @createTime 2016/12/23
 */
@Service("mediaAppActivityService")
public class MediaAppActivityServiceImpl implements MediaAppActivityService {

    @Autowired
    private ActivityDAO                   activityDAO;

    @Autowired
    private MediaAppActivityDAO           mediaAppActivityDAO;

    @Autowired
    private ActivityDirectAppCacheService activityDirectAppCacheService;

    @Override
    public Boolean activityDirectToMediaApp(Long activityId, Integer activityType, Integer directStatus, List<Long> appIds) throws TuiaMediaException {
        if (ActivityConstant.IS_DIRECT_MEDIA != directStatus && ActivityConstant.IS_NOT_DIRECT_MEDIA != directStatus) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        // 更新活动定向媒体字段
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setActivityType(activityType);
        activityDto.setIsDirectMedia(directStatus);
        activityDAO.update(activityDto);
        // 活动定向媒体更新
        mediaAppActivityDAO.delete(activityId, activityType);
        if (!CollectionUtils.isEmpty(appIds)) {
            List<MediaAppActivityDO> list = new ArrayList<>(appIds.size());
            for (Long appId : appIds) {
                MediaAppActivityDO mediaAppActivityDO = new MediaAppActivityDO();
                mediaAppActivityDO.setActivityId(activityId);
                mediaAppActivityDO.setActivityType(activityType);
                mediaAppActivityDO.setMediaAppId(appId);
                list.add(mediaAppActivityDO);
            }
            mediaAppActivityDAO.insertBatch(list);
            activityDirectAppCacheService.set(activityId, activityType, appIds);
        }
        return true;
    }

    @Override
    public Boolean activityDirectToMediaAppBySource(Long activityId, Integer activityType, Integer source, Integer directStatus,
                                                    List<Long> appIds) throws TuiaMediaException {
        if (ActivityConstant.IS_DIRECT_MEDIA != directStatus && ActivityConstant.IS_NOT_DIRECT_MEDIA != directStatus) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        // 更新活动定向媒体字段
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityId(activityId);
        activityDto.setSource(source);
        activityDto.setIsDirectMedia(directStatus);
        activityDAO.update(activityDto);
        // 活动定向媒体更新
        mediaAppActivityDAO.deleteBySource(activityId, source);
        if (!CollectionUtils.isEmpty(appIds)) {
            List<MediaAppActivityDO> list = new ArrayList<>(appIds.size());
            for (Long appId : appIds) {
                MediaAppActivityDO mediaAppActivityDO = new MediaAppActivityDO();
                mediaAppActivityDO.setActivityId(activityId);
                mediaAppActivityDO.setActivityType(activityType);
                mediaAppActivityDO.setSource(source);
                mediaAppActivityDO.setMediaAppId(appId);
                list.add(mediaAppActivityDO);
            }
            mediaAppActivityDAO.insertBatch(list);
            activityDirectAppCacheService.setBySource(activityId, source, appIds);
        }
        return true;
    }
}
