/**
 * Project Name:media-biz<br>
 * File Name:StatisticsServiceImpl.java<br>
 * Package Name:cn.com.duiba.tuia.media.service.impl<br>
 * Date:2016年10月10日下午4:32:09<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.media.api.dto.MeidaActivitySlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.SlotStatisticsDAO;
import cn.com.duiba.tuia.media.service.SlotStatisticsService;

/**
 * ClassName: StatisticsServiceImpl <br/>
 * date: 2016年10月10日 下午4:32:09 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@Service
public class SlotStatisticsServiceImpl implements SlotStatisticsService {

    @Autowired
    private SlotStatisticsDAO slotStatisticDAO;

    @Override
    public int getAdsenseDataAmount(ReqSlotStatisticsDto req) throws TuiaMediaException {
        return slotStatisticDAO.selectSlotDataAmout(req);
    }

    @Override
    public List<MeidaActivitySlotStatisticsDto> getAdsenseDataByPage(ReqSlotStatisticsDto req)
                                                                                              throws TuiaMediaException {
        return slotStatisticDAO.selectListSlotDataByPage(req);
    }

    @Override
    public int getMediaDataAmount(ReqMediaAppStatisticsDto req) throws TuiaMediaException {
        return slotStatisticDAO.selectMediaDataAmount(req);
    }

    @Override
    public List<MeidaActivitySlotStatisticsDto> getMediaDataByPage(ReqMediaAppStatisticsDto req)throws TuiaMediaException {
        return slotStatisticDAO.selectListMediaDataByPage(req);
    }

}
