/**
 * Project Name:media-biz<br/>
 * File Name:CheckAccountVaildStatus.java<br/>
 * Package Name:cn.com.duiba.tuia.media.utils<br/>
 * Date:2017年1月23日下午3:08:14<br/>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.utils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.AccountDAO;

/**
 * ClassName:CheckAccountVaildStatus <br/>
 * Function: 检查媒体账户有效状态公共方法. <br/>
 * Date: 2017年1月23日 下午3:08:14 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */

@Component
public class CheckAccountVaildStatus {

    @Autowired
    private AccountDAO accountDAO;

    /**
     * 
     * doGetAccountVaildStatus:(检查媒体账户有效状态). <br/>
     *
     * @author ZFZ
     * @param mediaId
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    public boolean doGetAccountVaildStatus(long mediaId) throws TuiaMediaException {
        boolean vaild = false;
        AccountDto accountDto = accountDAO.selectById(mediaId);

        if (accountDto != null && AccountDto.EMAIL_STATUS_CHECKED == accountDto.getEmailStatus() && AccountDto.UNFREEZED_STATUS == accountDto.getFreezeStatus()) {
            vaild = true;
        }

        return vaild;
    }
}
