/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppStatusDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.MediaAppDao;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqPageQueryMediaApp;
import cn.com.duiba.tuia.media.model.req.ReqUpdateMediaApp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;

@Repository(value="mediaAppDao")
public class MediaAppDaoImpl
extends BaseDAO
implements MediaAppDao {
    @Override
    public int insert(MediaAppDto param) throws TuiaMediaException {
        try {
            param.setGmtCreate(new Date());
            param.setGmtModified(param.getGmtCreate());
            return this.getSqlSession().insert(this.getStamentNameSpace("insert"), (Object)param);
        }
        catch (Exception e) {
            this.logger.error("MediaAppDaoImpl.createMediaApp happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<MediaAppDto> selectMediaAppList(ReqPageQueryMediaApp mediaAppQuery) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectMediaAppList"), (Object)mediaAppQuery);
        }
        catch (Exception e) {
            this.logger.error("MediaAppDaoImpl.getMediaAppList happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int update(ReqUpdateMediaApp param) throws TuiaMediaException {
        try {
            return this.getSqlSession().update(this.getStamentNameSpace("update"), (Object)param);
        }
        catch (Exception e) {
            this.logger.error("MediaAppDaoImpl.updateMediaApp happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public MediaAppDto selectMediaAppById(Long appId) throws TuiaMediaException {
        try {
            return (MediaAppDto)this.getSqlSession().selectOne(this.getStamentNameSpace("selectMediaAppById"), (Object)appId);
        }
        catch (Exception e) {
            this.logger.error("MediaAppDaoImpl.selectMediaAppById happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int selectAmountByPageQuery(ReqPageQueryMediaApp param) throws TuiaMediaException {
        try {
            return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("selectAmountByPageQuery"), (Object)param);
        }
        catch (Exception e) {
            this.logger.error("MediaAppDaoImpl.selectAmountByPageQuery happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<IdAndName> selectAppIdAndName(List<Long> ids) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(ids)) {
                return ListUtils.EMPTY_LIST;
            }
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectAppIdAndName"), ids);
        }
        catch (Exception e) {
            this.logger.error("MediaAppDaoImpl.selectAppIdAndName happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int updateMediaAppStatus(ReqUpdateMediaAppStatusDto param) throws TuiaMediaException {
        try {
            return this.getSqlSession().update(this.getStamentNameSpace("updateMediaAppStatus"), (Object)param);
        }
        catch (Exception e) {
            this.logger.error("MediaAppConfigDaoImpl.updateCheckStatus happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<Long> selectIdsByName(String appName) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectIdsByName"), (Object)appName);
        }
        catch (Exception e) {
            this.logger.error("MediaAppConfigDaoImpl.selectIdsByName happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public MediaAppDto getMediaAppByName(String appName) throws TuiaMediaException {
        try {
            return (MediaAppDto)this.getSqlSession().selectOne(this.getStamentNameSpace("getMediaAppByName"), (Object)appName);
        }
        catch (Exception e) {
            this.logger.error("MediaAppConfigDaoImpl.isMediaAppExists happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public MediaAppDto selectByAppKey(String appKey) throws TuiaMediaException {
        try {
            if (StringUtils.isEmpty((String)appKey)) {
                return null;
            }
            return (MediaAppDto)this.getSqlSession().selectOne(this.getStamentNameSpace("selectByAppKey"), (Object)appKey);
        }
        catch (Exception e) {
            this.logger.error("MediaAppConfigDaoImpl.selectByAppKey happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<IdAndName> selectAppIdAndNameByMediaId(Long mediaId) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectAppIdAndNameByMediaId"), (Object)mediaId);
        }
        catch (Exception e) {
            this.logger.error("MediaAppConfigDaoImpl.selectAppIdAndNameByMediaId happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<MediaAppDto> selectByIdAndName(Long appId, String appName) throws TuiaMediaException {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("appId", appId);
            map.put("appName", appName);
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectByIdAndName"), map);
        }
        catch (Exception e) {
            this.logger.error("MediaAppConfigDaoImpl.selectByIdAndName happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<IdAndName> selectAllAppIdAndName() throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectAllAppIdAndName"));
        }
        catch (Exception e) {
            this.logger.error("MediaAppConfigDaoImpl.selectAllAppIdAndName happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<MediaAppDto> selectAllAppCache() throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectAllAppCache"));
        }
        catch (Exception e) {
            this.logger.error("MediaAppConfigDaoImpl.selectAllAppCache happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

