/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.api.dto.SlotConfigDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.SlotConfigDAO;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="slotConfigDAO")
public class SlotConfigDAOImpl
extends BaseDAO
implements SlotConfigDAO {
    @Override
    public int insertSlotConfig(SlotConfigDto slotConfigDto) throws TuiaMediaException {
        try {
            return this.getSqlSession().insert(this.getStamentNameSpace("insertSlotConfig"), (Object)slotConfigDto);
        }
        catch (Exception e) {
            this.logger.error("SlotConfigDAO.insertSlotConfig happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public void updateSlotConfig(SlotConfigDto slotConfigDto) throws TuiaMediaException {
        try {
            this.getSqlSession().update(this.getStamentNameSpace("updateSlotConfig"), (Object)slotConfigDto);
        }
        catch (Exception e) {
            this.logger.error("SlotConfigDAO.updateSlotConfig happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public SlotConfigDto selectSlotConfigDto(Long slotId) throws TuiaMediaException {
        try {
            return (SlotConfigDto)this.getSqlSession().selectOne(this.getStamentNameSpace("selectSlotConfigDto"), (Object)slotId);
        }
        catch (Exception e) {
            this.logger.error("SlotConfigDAO.selectSlotConfigDto happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<SlotConfigDto> selectSlotConfigListByAppId(Long appId) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectSlotConfigListByAppId"), (Object)appId);
        }
        catch (Exception e) {
            this.logger.error("SlotConfigDAO.selectSlotConfigListByAppId happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

