/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.ActivityManualPlanDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivityManualBackendService;
import cn.com.duiba.tuia.media.dataobject.ActivityManualPlanDO;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.ActivityManualService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteActivityManualBackendServiceImpl
extends BaseRemoteService
implements RemoteActivityManualBackendService {
    private static final String TIME_DATE_FORMATE = "yyyy-MM-dd HH:mm:ss";
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityManualService activityManualService;

    public DubboResult<Boolean> addActivityManualPlan(ActivityManualPlanDto planDto) {
        try {
            ActivityManualPlanDO plan = new ActivityManualPlanDO();
            plan.setSource(planDto.getActSource());
            BeanUtils.copyProperties((Object)planDto, (Object)plan);
            if (planDto.getReleaseTime() != null) {
                String releaseTime = this.buildTime(planDto.getReleaseTime());
                plan.setReleaseTime(DateUtils.parseDate((String)releaseTime, (String[])new String[]{TIME_DATE_FORMATE}));
            }
            return DubboResult.successResult((Object)this.activityManualService.addActivityManualPlan(plan));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityManualServiceImpl.addActivityManualPlan is error, plan=" + planDto, (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<ActivityManualPlanDto>> findActivityManualPlans(Long slotId) {
        try {
            ArrayList<ActivityManualPlanDto> dtoList = new ArrayList<ActivityManualPlanDto>();
            List<ActivityManualPlanDO> list = this.activityManualService.findActivityManualPlans(slotId);
            for (ActivityManualPlanDO plan : list) {
                ActivityManualPlanDto planDto = new ActivityManualPlanDto();
                BeanUtils.copyProperties((Object)plan, (Object)planDto);
                if (plan.getReleaseTime() != null) {
                    planDto.setReleaseTime(new SimpleDateFormat(TIME_DATE_FORMATE).format(plan.getReleaseTime()));
                }
                if (0 == plan.getPlanType()) {
                    RspActivityDto activity = this.activityService.getActivityPlanDetailBySource(plan.getActivityId(), plan.getSource());
                    planDto.setActivityName(activity.getName());
                    planDto.setActivityStatus(activity.getIsEnable());
                }
                if (1 == plan.getPlanType()) {
                    planDto.setActivityStatus(Integer.valueOf(1));
                }
                if (!planDto.getActivityUrl().startsWith("http")) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("http:").append(planDto.getActivityUrl());
                    planDto.setActivityUrl(builder.toString());
                }
                dtoList.add(planDto);
            }
            return DubboResult.successResult(dtoList);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityManualServiceImpl.findActivityManualPlans is error, slotId=" + slotId, (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> modifyActivityManualPlan(ActivityManualPlanDto planDto) {
        try {
            ActivityManualPlanDO plan = new ActivityManualPlanDO();
            BeanUtils.copyProperties((Object)planDto, (Object)plan);
            if (planDto.getReleaseTime() != null) {
                String releaseTime = this.buildTime(planDto.getReleaseTime());
                plan.setReleaseTime(DateUtils.parseDate((String)releaseTime, (String[])new String[]{TIME_DATE_FORMATE}));
            }
            return DubboResult.successResult((Object)this.activityManualService.modifyActivityManualPlan(plan));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityManualServiceImpl.modifyActivityManualPlan is error, planDto=" + planDto, (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> removeActivityManualPlan(ActivityManualPlanDto planDto) {
        try {
            ActivityManualPlanDO plan = new ActivityManualPlanDO();
            BeanUtils.copyProperties((Object)planDto, (Object)plan);
            if (planDto.getReleaseTime() != null) {
                String releaseTime = this.buildTime(planDto.getReleaseTime());
                plan.setReleaseTime(DateUtils.parseDate((String)releaseTime, (String[])new String[]{TIME_DATE_FORMATE}));
            }
            return DubboResult.successResult((Object)this.activityManualService.removeActivityManualPlan(plan));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityManualServiceImpl.removeActivityManualPlan is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    private String buildTime(String releaseTime) {
        StringBuilder builder = new StringBuilder();
        builder.append(releaseTime);
        Calendar calendar = Calendar.getInstance();
        int seconds = calendar.get(13);
        builder.append(":");
        if (seconds < 10) {
            builder.append("0" + seconds);
        } else {
            builder.append(seconds);
        }
        return builder.toString();
    }

    public DubboResult<List<Long>> findActivityManualPlanSlot(Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult(this.activityManualService.findActivityManualPlanSlots(activityId, activityType));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityManualServiceImpl.findActivityManualPlanSlot is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<List<Long>> findActivityManualPlanSlotBySource(Long activityId, Integer source) {
        try {
            return DubboResult.successResult(this.activityManualService.findActivityManualPlanSlotsBySource(activityId, source));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivityManualServiceImpl.findActivityManualPlanSlot is error", (Throwable)e);
            return this.exceptionFailure(e);
        }
    }
}

