/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.ActivitySpmDto;
import cn.com.duiba.tuia.media.api.dto.SlotCacheDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivitySpmDAO;
import cn.com.duiba.tuia.media.dataobject.ActivitySpmDO;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySpmService;
import cn.com.duiba.tuia.media.service.impl.SlotCacheService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="activitySpmService")
public class ActivitySpmServiceImpl
implements ActivitySpmService {
    @Autowired
    private ActivitySpmDAO activitySpmDAO;
    @Autowired
    private SlotCacheService slotCacheService;
    @Autowired
    private ActivityService activityService;

    @Override
    public List<ActivitySpmDto> getSlotSpm(Long slotId, Integer statType) throws TuiaMediaException {
        if (1 == statType) {
            SlotCacheDto slotCacheDto = this.slotCacheService.getSlot(slotId);
            Long appId = slotCacheDto.getAppId();
            List<ActivitySpmDO> spm = this.activitySpmDAO.selectBySlot(slotId, appId, 1);
            if (!CollectionUtils.isEmpty(spm)) {
                return this.parseToDto(spm);
            }
        } else if (2 == statType) {
            List<ActivitySpmDO> spm = this.activitySpmDAO.selectBySlot(-1L, slotId, 2);
            if (!CollectionUtils.isEmpty(spm)) {
                return this.parseToDto(spm);
            }
        } else {
            List<ActivitySpmDO> spm = this.activitySpmDAO.selectBySlot(-1L, -1L, 3);
            if (!CollectionUtils.isEmpty(spm)) {
                return this.parseToDto(spm);
            }
        }
        return Collections.emptyList();
    }

    private List<ActivitySpmDto> parseToDto(List<ActivitySpmDO> list) {
        ArrayList<ActivitySpmDto> result = new ArrayList<ActivitySpmDto>();
        for (ActivitySpmDO activitySpmDO : list) {
            ActivitySpmDto activitySpmDto = new ActivitySpmDto();
            activitySpmDto.setActivityId(activitySpmDO.getActivityId());
            activitySpmDto.setActivityType(activitySpmDO.getActivityType());
            activitySpmDto.setSpm(activitySpmDO.getSpm());
            activitySpmDto.setStatType(activitySpmDO.getStatType());
            activitySpmDto.setSource(activitySpmDO.getSource());
            result.add(activitySpmDto);
        }
        return result;
    }

    private Map<Long, Integer> getActivitySpm(List<Long> activityIds, Integer statType) throws TuiaMediaException {
        HashMap<Long, Integer> spmMap = new HashMap<Long, Integer>();
        List<ActivitySpmDO> spmList = this.activitySpmDAO.selectByActivityOverall(activityIds);
        for (ActivitySpmDO spm : spmList) {
            spmMap.put(spm.getActivityId(), spm.getSpm() != null ? spm.getSpm().intValue() : 0);
        }
        return spmMap;
    }

    @Override
    public List<Long> getTuiaActivityIdList(int count) throws TuiaMediaException {
        List<Long> activityIds = this.activityService.getActivityBySource(1, count);
        if (CollectionUtils.isEmpty(activityIds)) {
            return Collections.emptyList();
        }
        final Map<Long, Integer> spmMap = this.getActivitySpm(activityIds, 3);
        Collections.sort(activityIds, new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                Integer spm1 = (Integer)spmMap.get(o1);
                Integer spm2 = (Integer)spmMap.get(o2);
                if (spm1 == null || spm2 == null) {
                    if (spm1 != null) {
                        return -1;
                    }
                    if (spm2 != null) {
                        return 1;
                    }
                    return 0;
                }
                return spm2 - spm1;
            }
        });
        return activityIds;
    }
}

