/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.req.ReqMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationItemDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationDAO;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationItemContentDAO;
import cn.com.duiba.tuia.media.dao.MaterialSpecificationItemDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationDO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationItemContentDO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationItemDO;
import cn.com.duiba.tuia.media.service.MaterialSpecificationService;
import cn.com.duiba.tuia.media.service.SlotService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="materialSpecificationService")
public class MaterialSpecificationServiceImpl
implements MaterialSpecificationService {
    @Autowired
    private MaterialSpecificationDAO materialSpecificationDAO;
    @Autowired
    private MaterialSpecificationItemDAO materialSpecificationItemDAO;
    @Autowired
    private SlotService slotService;
    @Autowired
    private MaterialSpecificationItemContentDAO materialSpecificationItemContentDAO;
    @Value(value="${media.material.specification.id}")
    private String materialSpecificationId;

    @Override
    public List<RspMaterialSpecificationDto> getMaterialSpecificationList(ReqMaterialSpecificationDto req) throws TuiaMediaException {
        req.setSort("gmt_modified");
        req.setOrder("desc");
        req.setRowStart(req.getPageSize() * (req.getCurrentPage() - 1));
        List<MaterialSpecificationDO> list = this.materialSpecificationDAO.getList(req);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<RspMaterialSpecificationDto>();
        }
        ArrayList<RspMaterialSpecificationDto> result = new ArrayList<RspMaterialSpecificationDto>(list.size());
        String[] ids = this.materialSpecificationId.split(",");
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
        for (String id : ids) {
            map.put(Long.valueOf(id), true);
        }
        for (MaterialSpecificationDO materialSpecificationDO : list) {
            RspMaterialSpecificationDto rspMaterialSpecificationDto = new RspMaterialSpecificationDto();
            BeanUtils.copyProperties((Object)materialSpecificationDO, (Object)rspMaterialSpecificationDto);
            if (map.get(rspMaterialSpecificationDto.getId()) != null && ((Boolean)map.get(rspMaterialSpecificationDto.getId())).booleanValue()) {
                rspMaterialSpecificationDto.setIsfixedData(Integer.valueOf(1));
            } else {
                rspMaterialSpecificationDto.setIsfixedData(Integer.valueOf(0));
            }
            result.add(rspMaterialSpecificationDto);
        }
        return result;
    }

    @Override
    public int getMaterialSpecificationAmount(ReqMaterialSpecificationDto req) throws TuiaMediaException {
        return this.materialSpecificationDAO.getAmount(req);
    }

    @Override
    @Transactional
    public Boolean deleteMaterialSpecification(Long msId) throws TuiaMediaException {
        this.slotService.closeSlotByMsId(msId);
        return this.materialSpecificationDAO.delete(msId) == 1;
    }

    @Override
    @Transactional
    public Boolean addMaterialSpecification(ReqMaterialSpecificationDto req) throws TuiaMediaException {
        MaterialSpecificationDO materialSpecificationDO = new MaterialSpecificationDO();
        materialSpecificationDO.setTitle(req.getTitle());
        materialSpecificationDO.setDescription(req.getDescription());
        materialSpecificationDO.setSchematicImg(req.getSchematicImg());
        if (req.getId() == null) {
            materialSpecificationDO.setIsDirect(0);
            this.materialSpecificationDAO.insert(materialSpecificationDO);
        } else {
            materialSpecificationDO.setId(req.getId());
            this.materialSpecificationDAO.update(materialSpecificationDO);
        }
        List msItemList = req.getItemDtoList();
        ArrayList<MaterialSpecificationItemDO> list = new ArrayList<MaterialSpecificationItemDO>(msItemList.size());
        for (RspMaterialSpecificationItemDto msItem : msItemList) {
            MaterialSpecificationItemDO materialSpecificationItemDO = new MaterialSpecificationItemDO();
            BeanUtils.copyProperties((Object)msItem, (Object)materialSpecificationItemDO);
            if (msItem.getId() != null) {
                this.materialSpecificationItemDAO.update(materialSpecificationItemDO);
                continue;
            }
            materialSpecificationItemDO.setMsId(materialSpecificationDO.getId());
            list.add(materialSpecificationItemDO);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.materialSpecificationItemDAO.insertBatch(list);
        }
        return true;
    }

    @Override
    public RspMaterialSpecificationDto getMaterialSpecificationDetail(Long msId) throws TuiaMediaException {
        MaterialSpecificationDO materialSpecificationDO = this.materialSpecificationDAO.getById(msId);
        if (materialSpecificationDO == null) {
            throw new TuiaMediaException(ErrorCode.E0501003);
        }
        RspMaterialSpecificationDto result = new RspMaterialSpecificationDto();
        BeanUtils.copyProperties((Object)materialSpecificationDO, (Object)result);
        List<MaterialSpecificationItemDO> msItemList = this.materialSpecificationItemDAO.getByMsId(materialSpecificationDO.getId());
        if (!CollectionUtils.isEmpty(msItemList)) {
            ArrayList<RspMaterialSpecificationItemDto> rspMsItemList = new ArrayList<RspMaterialSpecificationItemDto>(msItemList.size());
            for (MaterialSpecificationItemDO msItem : msItemList) {
                RspMaterialSpecificationItemDto rspMsItem = new RspMaterialSpecificationItemDto();
                BeanUtils.copyProperties((Object)msItem, (Object)rspMsItem);
                if (1 == rspMsItem.getItemType()) {
                    rspMsItemList.add(0, rspMsItem);
                    continue;
                }
                rspMsItemList.add(rspMsItemList.size(), rspMsItem);
            }
            result.setItemDtoList(rspMsItemList);
        }
        return result;
    }

    @Override
    public Map<Long, String> getMsNameByIds(List<Long> ids) throws TuiaMediaException {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap<Long, String>();
        }
        List<MaterialSpecificationDO> materialSpecificationDOList = this.materialSpecificationDAO.getByIds(ids);
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (MaterialSpecificationDO materialSpecificationDO : materialSpecificationDOList) {
            map.put(materialSpecificationDO.getId(), materialSpecificationDO.getTitle());
        }
        return map;
    }

    @Override
    public Map<Long, MaterialSpecificationDO> getMapByIds(List<Long> ids) throws TuiaMediaException {
        List<MaterialSpecificationDO> materialSpecificationDOList = this.materialSpecificationDAO.getByIds(ids);
        HashMap<Long, MaterialSpecificationDO> map = new HashMap<Long, MaterialSpecificationDO>();
        for (MaterialSpecificationDO materialSpecificationDO : materialSpecificationDOList) {
            map.put(materialSpecificationDO.getId(), materialSpecificationDO);
        }
        return map;
    }

    @Override
    public Boolean changeMsItemContentStatus(Long materialId) throws TuiaMediaException {
        return this.materialSpecificationItemContentDAO.changeStatus(materialId) > 0;
    }

    @Override
    public Map<Long, String> getMsImageUrl(List<Long> ids) throws TuiaMediaException {
        List<MaterialSpecificationItemContentDO> msList = this.materialSpecificationItemContentDAO.selectMsByIds(ids);
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (MaterialSpecificationItemContentDO dto : msList) {
            if (!StringUtils.contains((String)dto.getContent(), (String)",")) continue;
            map.put(dto.getId(), dto.getContent().split(",")[1]);
        }
        return map;
    }

    @Override
    public List<Long> getMsIdByName(String msName) throws TuiaMediaException {
        return this.materialSpecificationDAO.selectMsIdByName(msName);
    }
}

