package cn.com.duiba.tuia.media.common.constants;

/**
 * Function: 活动类型常量
 *
 * @author xuyenan
 * @createTime 2016/10/20
 */
public class ActivityTypeConstant {

    public static final int TypeDuibaActivity       = 0;  // 专题活动
    public static final int TypeTurnTable           = 1;  // 大转盘活动
    public static final int TypeDuibaSingleLottery  = 2;  // 兑吧单品抽奖
    public static final int TypeAppSingleLottery    = 3;  // APP自有单品抽奖
    public static final int TypeDuibaTurnTable      = 4;  // 兑吧大转盘
    public static final int TypeAppManualLottery    = 5;  // APP自有手动开奖
    public static final int TypeShakeLottery        = 6;  // 摇一摇
    public static final int TypeScratchCard         = 7;  // 刮刮卡
    public static final int TypeHdToolTurnTable     = 8;  // 活动工具大转盘
    public static final int TypeHdToolTiger         = 9;  // 老虎机
    public static final int TypeHdToolFlop          = 11; // 趣味翻牌
    public static final int TypeHdToolSmashg        = 12; // 砸彩蛋
    public static final int TypeSecondsKill         = 30; // 周三必抢
    public static final int TypeGameSanta           = 20; // 游戏活动-打劫圣诞老人
    public static final int TypeGameYearAward       = 21; // 游戏活动-数年终奖
    public static final int TypeGameGirl            = 22; // 游戏活动-女神PK
    public static final int TypeGameJiong           = 23; // 游戏活动-人在囧途
    public static final int TypeDuibaQuestionAnswer = 40; // 兑吧答题
    public static final int TypeDuibaQuizz          = 41; // 测试题
    public static final int TypeDuibaSecKill        = 31; // 兑吧秒杀活动
    public static final int TypeDuibaNgame          = 28; // 兑吧新游戏
    public static final int TypeDuibaGuess          = 42; // 兑吧竞猜
    public static final int TypeDuibaRob            = 45; // 今日必抢

    public static String getTypeText(Integer typeDuibaActivity) {
        String text = "未知";
        if (typeDuibaActivity == null) {
            return text;
        }
        switch (typeDuibaActivity) {
            case TypeDuibaActivity:
                text = "专题活动";
                break;
            case TypeTurnTable:
                text = "大转盘活动";
                break;
            case TypeDuibaSingleLottery:
                text = "兑吧单品抽奖";
                break;
            case TypeAppSingleLottery:
                text = "APP自有单品抽奖";
                break;
            case TypeDuibaTurnTable:
                text = "兑吧大转盘";
                break;
            case TypeAppManualLottery:
                text = "APP自有手动开奖";
                break;
            case TypeShakeLottery:
                text = "摇一摇";
                break;
            case TypeScratchCard:
                text = "刮刮乐";
                break;
            case TypeHdToolTurnTable:
                text = "大转盘";
                break;
            case TypeHdToolTiger:
                text = "摇奖机";
                break;
            case TypeHdToolFlop:
                text = "翻牌子";
                break;
            case TypeHdToolSmashg:
                text = "砸彩蛋";
                break;
            case TypeSecondsKill:
                text = "周三必抢";
                break;
            case TypeGameSanta:
                text = "游戏活动-打劫圣诞老人";
                break;
            case TypeGameYearAward:
                text = "游戏活动-数年终奖";
                break;
            case TypeGameGirl:
                text = "游戏活动-女神PK";
                break;
            case TypeGameJiong:
                text = "游戏活动-人在囧途";
                break;
            case TypeDuibaQuestionAnswer:
                text = "兑吧答题";
                break;
            case TypeDuibaQuizz:
                text = "测试题";
                break;
            case TypeDuibaSecKill:
                text = "兑吧秒杀活动";
                break;
            case TypeDuibaNgame:
                text = "兑吧新游戏";
                break;
            case TypeDuibaGuess:
                text = "兑吧竞猜";
                break;
            case TypeDuibaRob:
                text = "今日必抢";
                break;
        }
        return text;
    }
}
