/**
 * Project Name:media-common<br>
 * File Name:SlotPictureSizeEnmu.java<br>
 * Package Name:cn.com.duiba.tuia.media.common.constants<br>
 * Date:2016年10月19日下午7:52:36<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.common.constants;

/**
 * ClassName: SlotPictureSizeEnmu <br/>
 * Function: 广告位尺寸大小枚举. <br/>
 * date: 2016年10月19日 下午7:52:36 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public enum SlotPictureSizeEnmu {

    /** 600*300 */
    SIZE_0(0, 600, 300),

    /** 600*500 */
    SIZE_1(1, 600, 500),

    /** 600*270 */
    SIZE_2(2, 600, 270),

    /** 960*640 */
    SIZE_3(3, 960, 640),

    /** 800*120 */
    SIZE_4(4, 800, 120),

    /** 140*140 */
    SIZE_5(5, 140, 140),

    /** 1280*720 */
    SIZE_6(6, 1280, 720),
    
    /** 150*150 */
    SIZE_21(21, 150, 150),

    /** 500*500 */
    SIZE_41(41, 500, 500),

    /** 640*150 */
    SIZE_61(61, 640, 150),

    /** 640*280 */
    SIZE_81(81, 640, 280),

    ;

    /** 图片尺寸ID. */
    private int sizeId;

    /** 宽. */
    private int width;

    /** 高. */
    private int height;

    private SlotPictureSizeEnmu(int sizeId, int width, int height) {
        this.sizeId = sizeId;
        this.width = width;
        this.height = height;
    }

    public int getSizeId() {
        return sizeId;
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    /**
     * 根据sizeId查询具体的尺寸.
     *
     * @param id the id
     * @return the picture size by id
     */
    public static PictureSize getPictureSizeById(int sizeId) {
        SlotPictureSizeEnmu[] values = SlotPictureSizeEnmu.values();
        for (SlotPictureSizeEnmu value : values) {
            if (sizeId == value.getSizeId()) {
                return new PictureSize(value.getWidth(), value.getHeight());
            }
        }
        return null;
    }
    
    public static class PictureSize {

        /** 宽. */
        private int width;

        /** 高. */
        private int height;

        public PictureSize(int width, int height) {
            super();
            this.width = width;
            this.height = height;
        }

        public PictureSize() {
            super();
        }

        public int getWidth() {
            return width;
        }

        public int getHeight() {
            return height;
        }

    };

}
