package cn.com.duiba.tuia.media.common.tool;

import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
/**
 * 
 * 
 * 
 * 
 * 如果是Grails进入的请求，某些测试可以使用下面的方法获取:
 * There is a new forwardURI property using request.forwardURI and you can obtain other props using standard servlet request attributes:
 * public static final String FORWARD_REQUEST_URI_ATTRIBUTE = "javax.servlet.forward.request_uri";
 * public static final String FORWARD_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.forward.context_path";
 * public static final String FORWARD_SERVLET_PATH_ATTRIBUTE = "javax.servlet.forward.servlet_path";
 * public static final String FORWARD_PATH_INFO_ATTRIBUTE = "javax.servlet.forward.path_info";
 * public static final String FORWARD_QUERY_STRING_ATTRIBUTE = "javax.servlet.forward.query_string";
 * 
 * @author xuhengfei
 *
 */
public class RequestTool {
	
    private static final String DEFAULT_IP = "127.0.0.1";
	private static ThreadLocal<HttpServletRequest> request=new ThreadLocal<HttpServletRequest>();
	
	public static HttpServletRequest getHttpServletRequest(){
		return request.get();
	}
	
	public static void setRequestInThreadLocal(HttpServletRequest req){
		request.set(req);
	}
	
	public static String getRequestIpInThreadLocal(){
		HttpServletRequest req=request.get();
		if(req!=null){
			return getIpAddr(req);
		}
		return null;
	}
	
	public static String getRequestUAInThreadLocal(){
		HttpServletRequest req=request.get();
		if(req!=null){
			return req.getHeader("User-Agent");
		}
		return null;
	}
	
	public static String getNewRequestUrl(HttpServletRequest request){
		String url = ((HttpServletRequest) request).getRequestURL().toString();
		String queryString = ((HttpServletRequest) request).getQueryString();
		if(queryString==null){
			return url;
		}else{
			return url + "?" + queryString;
		}
	}
	
	public static String getRequestUrl(HttpServletRequest request){
		String queryString=request.getQueryString();

		if(queryString==null){
			queryString="";
		}else{
			queryString="?"+queryString;
		}
		if("post".equalsIgnoreCase(request.getMethod())){
			queryString="?"+queryString;
			Map<String, String[]> map=request.getParameterMap();
			for(String key:map.keySet()){
				if(map.get(key).length>0){
					queryString+=key+"="+map.get(key)[0]+"&";
				}
			}
		}
		String path=(String) request.getAttribute("javax.servlet.forward.request_uri");
		if(path!=null){
			return "http://"+request.getServerName()+":"+request.getServerPort()+path+queryString;
		}else{
			return request.getRequestURL().toString();
		}
	}
	public static String getIpAddr(HttpServletRequest request) {
		String ip = request.getHeader("x-forwarded-for");
		if(ip!=null && ip.trim().length()>0){
			String[] ips=ip.trim().split(",");
			int size=ips.length;
			if(size>0){
				ip=ips[size-1].trim();
			}
		}
		if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)){
			ip = request.getHeader("X-Real-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("WL-Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("Cdn-Src-Ip");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getRemoteAddr();
		}
		if(ip!=null && ip.startsWith("0:0:0:0")){
			ip=DEFAULT_IP;
		}
		return ip;
	}
	/**
	 * 获取操作系统类型：
	 * 	Android,iPhone,iPad,Mac,Windows,Linux
	 * @param request
	 * @return
	 */
	public static String getOS(HttpServletRequest request){
		String ua=request.getHeader("User-Agent");
		if(ua==null){
			return "Unkonwn";
		}
		ua=ua.toLowerCase();
		if(ua!=null){
			if(ua.contains("ipad")){
				return "iPad";
			}else if(ua.contains("iphone")){
				return "iPhone";
			}else if(ua.contains("android")){
				return "Android";
			}else if(ua.contains("linux")){
				return "Linux";
			}else if(ua.contains("windows")){
				return "Windows";
			}else if(ua.contains("macintosh")){
				return "Mac";
			}
		}
		return "Unknown";
	}
	
	public static boolean isLocalRequest(HttpServletRequest request){
		String ip=getIpAddr(request);
		if(ip.startsWith(DEFAULT_IP) || ip.startsWith("0:0:0:0")){
			return true;
		}
		return false;
	}
	
	public static boolean isHttpsRequest(HttpServletRequest request){
		if("true".equals(request.getHeader("Use-Https"))){
			return true;
		}
		return false;
	}
	
	public static String getCookie(HttpServletRequest request,String name){
		Cookie[] cookies=request.getCookies();
		if(cookies!=null){
			for(int i=0;i<cookies.length;i++){
		        Cookie c = cookies[i];
		        if(name.equals(c.getName())){
		        	String value=c.getValue();
		        	if(value!=null && value.length()>0){
		        		return value;
		        	}
		        }
			}
		}
		return null;
	}
	
	public static String getServerPath(HttpServletRequest request){
		String port = String.valueOf(request.getServerPort());
		if ("80".equals(port)) {
			port = "";
		} else {
			port = ":" + port;
		}
		String serverUrl = request.getScheme() + "://" + request.getServerName() + port;
		return serverUrl;
	}
}
