/**   
 * 文件名：  JsonUtils.java
 * 此类描述的是：  
 * 作者: leiliang   
 * 创建时间: 2016年3月23日 上午10:48:33  
 */   
package cn.com.duiba.tuia.media.common.utils;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.databind.ObjectMapper;


/**   
 * json相关  
 * <功能详细描述> 
 * @author: leiliang   
 * @version:  
 */
public class JsonUtils {
    
    /** The logger. */
    private static Logger                          logger = LoggerFactory.getLogger(JsonUtils.class);
    
	public static final ObjectMapper mapper = new ObjectMapper();
	public static String jsonString;
	
	/**
	 * 对象转JSON
	 * @param response
	 * @param obj
	 */
	public static void objToJSON(HttpServletResponse response,final Object obj) {
		try {
			setResponse(response);
			jsonString = mapper.writeValueAsString(obj);
			PrintWriter out = response.getWriter();
			out.print(jsonString);
			out.close();
		} catch (IOException e) {
		    logger.error("JsonUtils.objToJSON happen IOException", e);
		}
	}
	
	/**
	 * 对象转json
	 * @param obj
	 * @return
	 */
	public static String objectToString(Object obj){
		try {
			return mapper.writeValueAsString(obj);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	/**
	 * json转对象
	 * @param clazz
	 * @param json
	 * @return
	 */
	public static <T> T  jsonToObject(Class<T> clazz,String json){
		try {
			return mapper.readValue(json, clazz);
		} catch (Exception e) {
			throw new RuntimeException(e);
		} 
	}
	
	/**
	 * 设置编码格式
	 * @param response
	 */
	public static void setResponse(HttpServletResponse response){
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/html");
	}
}
