/**
 * 文件名： CollectionUtil.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月22日 下午4:19:58
 */
package cn.com.duiba.tuia.media.common.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/**
 * 此类用来操作list <功能详细描述>
 * 
 * @author: sunjiangrong
 * @创建时间: 2016年4月22日 下午4:19:58
 * @version:
 */
public class CollectionUtil
{
	
	private CollectionUtil()
	{
		
	}
	
	/**
	 * 获取两个集合的不同元素 <一句话功能描述>
	 * 
	 * @param collmax
	 * @param collmin
	 * @return
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static Collection getDiffent(Collection collmax, Collection collmin)
	{
		Collection csReturn = new LinkedList();
		Collection max = collmax;
		Collection min = collmin;
		
		// 先比较大小,这样会减少后续map的if判断次数
		if (collmax.size() < collmin.size())
		{
			max = collmin;
			min = collmax;
		}
		// 直接指定大小,防止再散列
		Map<Object, Integer> map = new HashMap<Object, Integer>(max.size());
		for (Object object : max)
		{
			map.put(object, 1);
		}
		for (Object object : min)
		{
			if (map.get(object) == null)
			{
				csReturn.add(object);
			}
			else
			{
				map.put(object, 2);
			}
			
		}
		for (Map.Entry<Object, Integer> entry : map.entrySet())
		{
			if (entry.getValue() == 1)
			{
				csReturn.add(entry.getKey());
			}
		}
		
		return csReturn;
	}
	
	/**
	 * 判断两个集合中是否有相同的元素 <一句话功能描述>
	 * 
	 * @param collmax
	 * @param collmin
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	public static boolean haveSame(Collection collmax, Collection collmin)
	{
		if (collmax == null || collmin == null || collmax.size() == 0 || collmin.size() == 0)
		{
			return false;
		}
		Collection max = collmax;
		Collection min = collmin;
		// 先比较大小,这样会减少后续map的if判断次数
		if (collmax.size() < collmin.size())
		{
			max = collmin;
			min = collmax;
		}
		// 直接指定大小,防止再散列
		Map<Object, Integer> map = new HashMap<Object, Integer>(max.size());
		for (Object object : max)
		{
			map.put(object, 1);
		}
		for (Object object : min)
		{
			// 如果遇上相同的直接返回true
			if (map.get(object) != null)
			{
				return true;
			}
		}
		
		return false;
	}
}
