/**
 * 文件名： TuiaException.java 此类描述的是： 作者: leiliang 创建时间: 2016年3月23日 上午10:16:44
 */
package cn.com.duiba.tuia.media.common.exception;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;

/**
 * 推啊内部异常 <功能详细描述>.
 *
 * @author: leiliang
 * @version:
 */
public class TuiaMediaException extends Exception {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 4488920747852502701L;

    /** The result code. */
    private final String      resultCode;

    /** The result message. */
    private final String      resultMessage;

    /**
     * The Constructor.
     *
     * @param code the code
     */
    public TuiaMediaException(ErrorCode code) {
        super();
        this.resultCode = code.getErrorCode();
        this.resultMessage = code.getDesc();
    }

    /**
     * The Constructor.
     *
     * @param code the code
     * @param cause the cause
     */
    public TuiaMediaException(ErrorCode code, Throwable cause) {
        super(cause);
        this.resultCode = code.getErrorCode();
        this.resultMessage = code.getDesc();
    }

    /**
     * The Constructor.
     * 
     * @param code
     * @param desc
     */
    public TuiaMediaException(String code, String desc) {
        super();
        this.resultCode = code;
        this.resultMessage = desc;
    }

    /**
     * Gets the result code.
     *
     * @return the resultCode
     */
    public String getResultCode() {
        return resultCode;
    }

    /**
     * Gets the result message.
     *
     * @return the resultMessage
     */
    public String getResultMessage() {
        return resultMessage;
    }

    /**
     *
     * @return the string
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TCFException [resultCode=");
        builder.append(resultCode);
        builder.append(", resultMessage=");
        builder.append(resultMessage);
        builder.append("]");
        return builder.toString();
    }

}
