/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.common.utils;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static Logger logger = LoggerFactory.getLogger(JsonUtils.class);
    public static final ObjectMapper mapper = new ObjectMapper();
    private static String jsonString;
    private JsonUtils ju;

    public JsonUtils getJsonUtils() {
        if (this.ju == null) {
            this.ju = new JsonUtils();
        }
        return this.ju;
    }

    private static String getJsonString() {
        return jsonString;
    }

    public static void setJsonString(String jsonString) {
        JsonUtils.setJsonString(jsonString);
    }

    public static void objToJSON(HttpServletResponse response, Object obj) {
        try {
            JsonUtils.setResponse(response);
            JsonUtils.setJsonString(mapper.writeValueAsString(obj));
            PrintWriter out = response.getWriter();
            out.print(JsonUtils.getJsonString());
            out.close();
        }
        catch (IOException e) {
            logger.error("JsonUtils.objToJSON happen IOException", (Throwable)e);
        }
    }

    public static String objectToString(Object obj) throws TuiaMediaException {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            logger.error("JsonUtils.objectToString happen Exception", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
    }

    public static <T> T jsonToObject(Class<T> clazz, String json) throws TuiaMediaException {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            logger.error("JsonUtils.jsonToObject happen Exception", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
    }

    public static void setResponse(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
    }
}

