/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.model.req.ReqDelete;
import cn.com.duiba.tuia.media.model.req.ReqShieldListStrategy;
import cn.com.duiba.tuia.media.model.req.ReqStrategyPageQuery;
import cn.com.duiba.tuia.media.model.rsp.RspIdAndValue;
import cn.com.duiba.tuia.media.model.rsp.RspPageResult;
import cn.com.duiba.tuia.media.model.rsp.RspShieldStrategy;
import cn.com.duiba.tuia.media.model.rsp.RspStrategyList;
import cn.com.duiba.tuia.media.service.StrategyService;
import cn.com.duiba.tuia.media.utils.RequestLocal;
import cn.com.duiba.tuia.media.web.aop.LogWrite;
import cn.com.duiba.tuia.media.web.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/strategy"})
@Api(value="\u5c4f\u853d\u7b56\u7565\u76f8\u5173api")
public class StrategyController
extends BaseController {
    @Autowired
    private StrategyService strategyService;

    @LogWrite(modelName="\u5c4f\u853d\u7b56\u7565\u6a21\u5757", option="\u521b\u5efa\u5c4f\u853d\u7b56\u7565")
    @ResponseBody
    @ApiOperation(value="\u521b\u5efa\u5c4f\u853d\u7b56\u7565", httpMethod="POST", notes="\u521b\u5efa\u5c4f\u853d\u7b56\u7565\u63a5\u53e3")
    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public Result<Boolean> create(@Valid @RequestBody ReqShieldListStrategy param, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.strategyService.create(param));
        }
        catch (Exception e) {
            this.logger.error("StrategyController.create error!,the param=[{}]", (Object)param);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u5c4f\u853d\u7b56\u7565\u6a21\u5757", option="\u66f4\u65b0\u5c4f\u853d\u7b56\u7565")
    @ResponseBody
    @ApiOperation(value="\u66f4\u65b0\u5c4f\u853d\u7b56\u7565", httpMethod="POST", notes="\u66f4\u65b0\u5c4f\u853d\u7b56\u7565\u63a5\u53e3")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public Result<Boolean> update(@Valid @RequestBody ReqShieldListStrategy param, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.strategyService.update(param));
        }
        catch (Exception e) {
            this.logger.error("StrategyController.update error!,the param=[{}]", (Object)param);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u5c4f\u853d\u7b56\u7565\u6a21\u5757", option="\u5220\u9664\u5c4f\u853d\u7b56\u7565")
    @ResponseBody
    @ApiOperation(value="\u5220\u9664\u5c4f\u853d\u7b56\u7565", httpMethod="POST", notes="\u5220\u9664\u5c4f\u853d\u7b56\u7565\u63a5\u53e3")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public Result<Boolean> delete(@RequestBody ReqDelete req, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.strategyService.delete(RequestLocal.get().getCid(), req.getId()));
        }
        catch (Exception e) {
            this.logger.error("StrategyController.delete error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u5c4f\u853d\u7b56\u7565\u8be6\u60c5", httpMethod="GET", notes="\u67e5\u8be2\u5c4f\u853d\u7b56\u7565\u8be6\u60c5\u63a5\u53e3")
    @RequestMapping(value={"/getDetail"}, method={RequestMethod.GET})
    public Result<RspShieldStrategy> getDetail(@RequestParam Long id) {
        try {
            return this.successResult(this.strategyService.getDetail(id));
        }
        catch (Exception e) {
            this.logger.error("StrategyController.getDetail error!,the param=[{}]", (Object)id);
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u5c4f\u853d\u7b56\u7565\u5217\u8868", httpMethod="GET", notes="\u67e5\u8be2\u5c4f\u853d\u7b56\u7565\u5217\u8868\u63a5\u53e3")
    @RequestMapping(value={"/getListByMediaId"}, method={RequestMethod.GET})
    public Result<List<RspIdAndValue>> getListByMediaId() {
        try {
            return this.successResult(this.strategyService.getListByMediaId(RequestLocal.get().getCid()));
        }
        catch (Exception e) {
            this.logger.error("StrategyController.getList error!");
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5c4f\u853d\u7b56\u7565", httpMethod="GET", notes="\u5206\u9875\u67e5\u8be2\u5c4f\u853d\u7b56\u7565\u63a5\u53e3")
    @RequestMapping(value={"/getPageList"}, method={RequestMethod.GET})
    public Result<RspPageResult<RspStrategyList>> getPageList(@ModelAttribute ReqStrategyPageQuery req) {
        try {
            if (req.getPageSize() == null) {
                req.setPageSize(Integer.valueOf(50));
            }
            req.setRowStart((req.getCurrentPage() - 1) * req.getPageSize());
            req.setMediaId(RequestLocal.get().getCid());
            return this.successResult(this.strategyService.getPageList(req));
        }
        catch (Exception e) {
            this.logger.error("StrategyController.getPageList error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }
}

