package cn.com.duiba.tuia.media.web;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.web.SpringBootServletInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

/**
 * The Class Application.
 */
@Configuration
@ImportResource({ "spring/spring.xml" })
@SpringBootApplication
public class Application extends SpringBootServletInitializer {

    private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) {
        ConfigurableApplicationContext ctx = null;
        try {
            long start = System.currentTimeMillis();
            ctx = SpringApplication.run(Application.class, args);
            Thread.sleep(Long.MAX_VALUE);
            long period = System.currentTimeMillis() - start;
            LOGGER.error("Application start successfully in " + period + " ms.");
        } catch (Exception e) {
            LOGGER.error("Application start error :", e);
            System.exit(-1);
        } finally {
            if (ctx != null) {
                ctx.close();
            }
        }
    }
}
