/**
 * Project Name:tuia-web<br>
 * File Name:SwaggerConfig.java<br>
 * Package Name:cn.com.duiba.tuia<br>
 * Date:2016年9月6日上午11:39:43<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 *
 */
package cn.com.duiba.tuia.media.web;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;



/**
 * ClassName: SwaggerConfig <br/>
 * date: 2016年9月6日 上午11:39:43 <br/>
 *
 * @author leiliang
 * @version 
 * @since JDK 1.6
 */
@Configuration
@EnableSwagger2
public class SwaggerConfig {

    @Value("${media.swagger.enable}")
    private Boolean swaggerEnbale;
    
    @Bean
    public Docket createRestApi(){

        return new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo())
                .enable(swaggerEnbale)
                .select()
                .apis(RequestHandlerSelectors.basePackage("cn.com.duiba.tuia"))
                .paths(PathSelectors.regex("/*/.*"))
                .build();
    }

    private ApiInfo apiInfo(){
        return new ApiInfoBuilder().title("兑吧Api文档")
                .description("媒体业务平台的RESTful API文档")
                .termsOfServiceUrl("")
                .contact("leiliang@duiba.com.cn")
                .version("1.0")
                .build();
    }
}
