/**
 * 文件名： BaseController.java 此类描述的是： 作者: leiliang 创建时间: 2016年3月23日 上午11:51:35
 */
package cn.com.duiba.tuia.media.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ExceptionHandler;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.utils.ResultUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 公共的Controller.
 *
 * @author: leiliang
 * @version:
 */
public class BaseController {

    /** The logger. */
    protected Logger logger = LoggerFactory.getLogger(getClass());

    /**
     * 异常处理.
     *
     * @param e the e
     * @param response the response
     */
    @ExceptionHandler
    public <T> Result<T> failResult(Exception e) {
        if (e instanceof TuiaMediaException) {
            TuiaMediaException e1 = (TuiaMediaException) e;
            logger.error("发生内部错误, because of=[{}]", e1.getResultMessage());
            return ResultUtil.fail(e1.getResultCode(), e1.getResultMessage());
        } else {
            logger.error("发生系统错误", e);
            return ResultUtil.fail(ErrorCode.E9999999);
        }
    }

    /**
     * tuia-core错误码转换.
     *
     * @param <T> the generic type
     * @param result the result
     * @param callInterface the call interface
     * @throws TuiaMediaException the tuia media exception
     */
    protected <T> void doTuiaCoreException(DubboResult<T> result, String callInterface) throws TuiaMediaException {
        if (!result.isResultSuccess()) {
            String returnCode = result.getReturnCode();
            String msg = result.getMsg();
            // 创建失败
            logger.error("[TuiaCore] " + callInterface + " failed, because of=[{}] and the returnCode=[{}]",
                         result.getMsg(), returnCode);
            if (returnCode.endsWith("9999999")) {
                // 如果不是tuia-core发生的未知错误， 则把错误描述返回给前端
                msg = "发生未知错误";
                returnCode = "9999999";
            }
            throw new TuiaMediaException(returnCode, msg);
        }
    }

    /**
     * Success.<br>
     * 【使用场景】<br>
     * desc不用特别说明
     * 
     * @param <T> the generic type
     * @param t 返回数据
     * @param desc 成功描述语
     */
    public <T> Result<T> successResult(T t) {
        return ResultUtil.success(t);
    }

    /**
     * Success.<br>
     * 【使用场景】<br>
     * 没有返回结果的情况， 如审核等操作
     * 
     * @param desc 成功描述语
     */
    public <T> Result<T> successResult() {
        return ResultUtil.success();
    }

    /**
     * 参数校验.
     *
     * @param result the result
     * @throws TuiaManagerException the tuia manager exception
     */
    public void checkParam(BindingResult result) throws TuiaMediaException {
        if (result.hasErrors()) {
            logger.error("[param] error, because of " + result.getFieldError());
            throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), result.getFieldError().getDefaultMessage());
        }
    }
}
