/**
 * Project Name:media-deploy<br>
 * File Name:TagController.java<br>
 * Package Name:cn.com.duiba.tuia.media.web.controller<br>
 * Date:2016年9月27日下午7:06:06<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.web.controller;

import java.util.ArrayList;
import java.util.List;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.dubbo.common.utils.CollectionUtils;

import cn.com.duiba.tuia.core.api.dto.TagLevel;
import cn.com.duiba.tuia.core.api.remoteservice.RemoteTagBackendService;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.utils.RemoveDuplicateTool;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: TagController <br/>
 * Function: 标签. <br/>
 * date: 2016年9月27日 下午7:06:06 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@Controller
@RequestMapping("/tag")
@Api("标签相关api")
public class TagController extends BaseController {

    @Autowired
    private RemoteTagBackendService remoteTagBackendService;

    @ResponseBody
    @ApiOperation(value = "查询行业分类", httpMethod = "GET", notes = "查询行业分类接口")
    @RequestMapping(value = "/getIndustries", method = RequestMethod.GET)
    public Result<List<String>> getIndustries() {
        try {
            // 参数校验
            DubboResult<List<String>> dubboResult = remoteTagBackendService.getIndustries();
            doTuiaCoreException(dubboResult, "remoteTagBackendService.getIndustries");
            List<String> result = dubboResult.getResult();
            // 去除重复的行业
            return successResult(RemoveDuplicateTool.doRemoveDuplicate(result));
        } catch (Exception e) {
            logger.error("TagController.getIndustries error!");
            return failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value = "查询行业所有标签", httpMethod = "GET", notes = "查询行业所有标签接口")
    @RequestMapping(value = "/getAllIndustries", method = RequestMethod.GET)
    public Result<List<String>> getAllIndustries() {
        try {
            // 参数校验
            DubboResult<List<TagLevel>> dubboResult = remoteTagBackendService.getAllIndustries();
            doTuiaCoreException(dubboResult, "remoteTagBackendService.getAllIndustries");
            // 获取屏蔽行业
            List<TagLevel> result = dubboResult.getResult();
            List<String> rspAllTags = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(result)) {
                rspAllTags = doGetTag(result);
            }
            return successResult(rspAllTags);
        } catch (Exception e) {
            logger.error("TagController.getAllIndustries error!");
            return failResult(e);
        }
    }

    /**
     * 返回屏蔽标签. <br/>
     *
     * @author xiawei
     * @param dubboResult
     * @return
     * @since JDK 1.6
     */
    private List<String> doGetTag(List<TagLevel> result) {

        List<String> rspAllTags = new ArrayList<>();
        for (TagLevel tagLevel : result) {
            rspAllTags = doRecursion(rspAllTags, tagLevel);
        }

        return RemoveDuplicateTool.doRemoveDuplicate(rspAllTags);
    }

    /**
     * doRecursion:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author xiawei
     * @param rspAllTags
     * @param tagLevel
     * @since JDK 1.6
     */
    private List<String> doRecursion(List<String> rspAllTags, TagLevel tagLevel) {
        if (CollectionUtils.isNotEmpty(tagLevel.getChildren())) {
            List<String> rsgTags = new ArrayList<>();
            for (TagLevel tag : tagLevel.getChildren()) {
                rsgTags.add(tag.getText());
                doRecursion(rspAllTags, tag);
            }
            rspAllTags.addAll(rsgTags);
        }
        return rspAllTags;
    }

}
