/**
 * 
 */
package cn.com.duiba.tuia.media.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.tool.IDGeneratorTool;
import cn.com.duiba.tuia.media.common.tool.UploadTool;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.model.rsp.UploadRsp;

/**
 * @author Sunjiangrong
 */
@Controller
@RequestMapping("/upload")
@Api("文件上传api")
public class UploadController extends BaseController {

    @ApiOperation(value = "上传营业照", httpMethod = "POST", notes = "上传营业照接口")
    @ResponseBody
    @RequestMapping(value = "/index", method = RequestMethod.POST)
    public Result<UploadRsp> upload(HttpServletRequest request, HttpServletResponse response) {
        try {
            // 解析器解析request的上下文
            CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(
                                                                                      request.getSession().getServletContext());
            // 先判断request中是否包涵multipart类型的数据，
            if (!multipartResolver.isMultipart(request)) {
                throw new TuiaMediaException(ErrorCode.E9999999);
            }

            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;

            MultipartFile mf = multipartRequest.getFile("file");
            if (mf == null) {
                throw new TuiaMediaException(ErrorCode.E0001005);
            }
            String fileName = mf.getOriginalFilename();
            String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
            if (fileType.equalsIgnoreCase("jpg") || fileType.equalsIgnoreCase("jpeg")
                || fileType.equalsIgnoreCase("png") || fileType.equalsIgnoreCase("gif")) {
                String name = IDGeneratorTool.getRandomString(10) + "." + fileType;
                String path = "tuia-media/img/" + name;
                InputStream inputStream = null;
                try {
                    inputStream = mf.getInputStream();
                } catch (IOException e) {
                    logger.error("upload file error", e);
                    throw new TuiaMediaException(ErrorCode.E0003003);
                }
                long size = mf.getSize();

                UploadTool.uploadOssImg(inputStream, path, size);
                UploadRsp rsp = new UploadRsp();
                rsp.setFileName(fileName);
                rsp.setUrl(UploadTool.getTuiaUrl() + path);

                return successResult(rsp);
            } else {
                // 文件类型不符
                logger.error("not supported [{}] file type", fileType);
                throw new TuiaMediaException(ErrorCode.E0002005);
            }
        } catch (Exception e) {
            logger.error("upload error!");
            return failResult(e);
        }
    }
}
