/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.client.impl.producer;

import com.alibaba.rocketmq.client.QueryResult;
import com.alibaba.rocketmq.client.Validators;
import com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.client.hook.CheckForbiddenContext;
import com.alibaba.rocketmq.client.hook.CheckForbiddenHook;
import com.alibaba.rocketmq.client.hook.SendMessageContext;
import com.alibaba.rocketmq.client.hook.SendMessageHook;
import com.alibaba.rocketmq.client.impl.CommunicationMode;
import com.alibaba.rocketmq.client.impl.MQClientManager;
import com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.alibaba.rocketmq.client.impl.producer.MQProducerInner;
import com.alibaba.rocketmq.client.impl.producer.TopicPublishInfo;
import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.alibaba.rocketmq.client.producer.LocalTransactionExecuter;
import com.alibaba.rocketmq.client.producer.LocalTransactionState;
import com.alibaba.rocketmq.client.producer.MessageQueueSelector;
import com.alibaba.rocketmq.client.producer.SendCallback;
import com.alibaba.rocketmq.client.producer.SendResult;
import com.alibaba.rocketmq.client.producer.SendStatus;
import com.alibaba.rocketmq.client.producer.TransactionCheckListener;
import com.alibaba.rocketmq.client.producer.TransactionMQProducer;
import com.alibaba.rocketmq.client.producer.TransactionSendResult;
import com.alibaba.rocketmq.common.MixAll;
import com.alibaba.rocketmq.common.ServiceState;
import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.help.FAQUrl;
import com.alibaba.rocketmq.common.message.Message;
import com.alibaba.rocketmq.common.message.MessageAccessor;
import com.alibaba.rocketmq.common.message.MessageDecoder;
import com.alibaba.rocketmq.common.message.MessageExt;
import com.alibaba.rocketmq.common.message.MessageId;
import com.alibaba.rocketmq.common.message.MessageQueue;
import com.alibaba.rocketmq.common.protocol.header.CheckTransactionStateRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.EndTransactionRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.SendMessageRequestHeader;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.alibaba.rocketmq.remoting.exception.RemotingException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class DefaultMQProducerImpl
implements MQProducerInner {
    private final Logger log = ClientLogger.getLog();
    private final DefaultMQProducer defaultMQProducer;
    private final ConcurrentHashMap<String, TopicPublishInfo> topicPublishInfoTable = new ConcurrentHashMap();
    protected BlockingQueue<Runnable> checkRequestQueue;
    protected ExecutorService checkExecutor;
    private ServiceState serviceState = ServiceState.CREATE_JUST;
    private MQClientInstance mQClientFactory;
    private final ArrayList<SendMessageHook> sendMessageHookList = new ArrayList();
    private ArrayList<CheckForbiddenHook> checkForbiddenHookList = new ArrayList();
    private final RPCHook rpcHook;
    private int zipCompressLevel = Integer.parseInt(System.getProperty("rocketmq.message.compressLevel", "5"));

    public DefaultMQProducerImpl(DefaultMQProducer defaultMQProducer, RPCHook rpcHook) {
        this.defaultMQProducer = defaultMQProducer;
        this.rpcHook = rpcHook;
    }

    public DefaultMQProducerImpl(DefaultMQProducer defaultMQProducer) {
        this(defaultMQProducer, null);
    }

    public boolean hasCheckForbiddenHook() {
        return !this.checkForbiddenHookList.isEmpty();
    }

    public void registerCheckForbiddenHook(CheckForbiddenHook checkForbiddenHook) {
        this.checkForbiddenHookList.add(checkForbiddenHook);
        this.log.info("register a new checkForbiddenHook. hookName={}, allHookSize={}", (Object)checkForbiddenHook.hookName(), (Object)this.checkForbiddenHookList.size());
    }

    public void executeCheckForbiddenHook(CheckForbiddenContext context) throws MQClientException {
        if (this.hasCheckForbiddenHook()) {
            for (CheckForbiddenHook hook : this.checkForbiddenHookList) {
                hook.checkForbidden(context);
            }
        }
    }

    public void initTransactionEnv() {
        TransactionMQProducer producer = (TransactionMQProducer)this.defaultMQProducer;
        this.checkRequestQueue = new LinkedBlockingQueue<Runnable>(producer.getCheckRequestHoldMax());
        this.checkExecutor = new ThreadPoolExecutor(producer.getCheckThreadPoolMinSize(), producer.getCheckThreadPoolMaxSize(), 60000L, TimeUnit.MILLISECONDS, this.checkRequestQueue);
    }

    public void destroyTransactionEnv() {
        this.checkExecutor.shutdown();
        this.checkRequestQueue.clear();
    }

    public boolean hasSendMessageHook() {
        return !this.sendMessageHookList.isEmpty();
    }

    public void registerSendMessageHook(SendMessageHook hook) {
        this.sendMessageHookList.add(hook);
        this.log.info("register sendMessage Hook, {}", (Object)hook.hookName());
    }

    public void executeSendMessageHookBefore(SendMessageContext context) {
        if (!this.sendMessageHookList.isEmpty()) {
            for (SendMessageHook hook : this.sendMessageHookList) {
                try {
                    hook.sendMessageBefore(context);
                }
                catch (Throwable e) {}
            }
        }
    }

    public void executeSendMessageHookAfter(SendMessageContext context) {
        if (!this.sendMessageHookList.isEmpty()) {
            for (SendMessageHook hook : this.sendMessageHookList) {
                try {
                    hook.sendMessageAfter(context);
                }
                catch (Throwable e) {}
            }
        }
    }

    public void start() throws MQClientException {
        this.start(true);
    }

    public void start(boolean startFactory) throws MQClientException {
        switch (this.serviceState) {
            case CREATE_JUST: {
                this.serviceState = ServiceState.START_FAILED;
                this.checkConfig();
                if (!this.defaultMQProducer.getProducerGroup().equals("CLIENT_INNER_PRODUCER")) {
                    this.defaultMQProducer.changeInstanceNameToPID();
                }
                this.mQClientFactory = MQClientManager.getInstance().getAndCreateMQClientInstance(this.defaultMQProducer, this.rpcHook);
                boolean registerOK = this.mQClientFactory.registerProducer(this.defaultMQProducer.getProducerGroup(), this);
                if (!registerOK) {
                    this.serviceState = ServiceState.CREATE_JUST;
                    throw new MQClientException("The producer group[" + this.defaultMQProducer.getProducerGroup() + "] has been created before, specify another name please." + FAQUrl.suggestTodo((String)"http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&group_duplicate"), null);
                }
                this.topicPublishInfoTable.put(this.defaultMQProducer.getCreateTopicKey(), new TopicPublishInfo());
                if (startFactory) {
                    this.mQClientFactory.start();
                }
                this.log.info("the producer [{}] start OK", (Object)this.defaultMQProducer.getProducerGroup());
                this.serviceState = ServiceState.RUNNING;
                break;
            }
            case RUNNING: 
            case START_FAILED: 
            case SHUTDOWN_ALREADY: {
                throw new MQClientException("The producer service state not OK, maybe started once, " + this.serviceState + FAQUrl.suggestTodo((String)"http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&service_not_ok"), null);
            }
        }
        this.mQClientFactory.sendHeartbeatToAllBrokerWithLock();
    }

    private void checkConfig() throws MQClientException {
        Validators.checkGroup(this.defaultMQProducer.getProducerGroup());
        if (null == this.defaultMQProducer.getProducerGroup()) {
            throw new MQClientException("producerGroup is null", null);
        }
        if (this.defaultMQProducer.getProducerGroup().equals("DEFAULT_PRODUCER")) {
            throw new MQClientException("producerGroup can not equal DEFAULT_PRODUCER, please specify another one.", null);
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean shutdownFactory) {
        switch (this.serviceState) {
            case CREATE_JUST: {
                break;
            }
            case RUNNING: {
                this.mQClientFactory.unregisterProducer(this.defaultMQProducer.getProducerGroup());
                if (shutdownFactory) {
                    this.mQClientFactory.shutdown();
                }
                this.log.info("the producer [{}] shutdown OK", (Object)this.defaultMQProducer.getProducerGroup());
                this.serviceState = ServiceState.SHUTDOWN_ALREADY;
                break;
            }
            case SHUTDOWN_ALREADY: {
                break;
            }
        }
    }

    @Override
    public Set<String> getPublishTopicList() {
        HashSet<String> topicList = new HashSet<String>();
        for (String key : this.topicPublishInfoTable.keySet()) {
            topicList.add(key);
        }
        return topicList;
    }

    @Override
    public boolean isPublishTopicNeedUpdate(String topic) {
        TopicPublishInfo prev = this.topicPublishInfoTable.get(topic);
        return null == prev || !prev.ok();
    }

    @Override
    public TransactionCheckListener checkListener() {
        if (this.defaultMQProducer instanceof TransactionMQProducer) {
            TransactionMQProducer producer = (TransactionMQProducer)this.defaultMQProducer;
            return producer.getTransactionCheckListener();
        }
        return null;
    }

    @Override
    public void checkTransactionState(final String addr, final MessageExt msg, final CheckTransactionStateRequestHeader header) {
        Runnable request = new Runnable(){
            private final String brokerAddr;
            private final MessageExt message;
            private final CheckTransactionStateRequestHeader checkRequestHeader;
            private final String group;
            {
                this.brokerAddr = addr;
                this.message = msg;
                this.checkRequestHeader = header;
                this.group = DefaultMQProducerImpl.this.defaultMQProducer.getProducerGroup();
            }

            @Override
            public void run() {
                TransactionCheckListener transactionCheckListener = DefaultMQProducerImpl.this.checkListener();
                if (transactionCheckListener != null) {
                    LocalTransactionState localTransactionState = LocalTransactionState.UNKNOW;
                    Throwable exception = null;
                    try {
                        localTransactionState = transactionCheckListener.checkLocalTransactionState(this.message);
                    }
                    catch (Throwable e) {
                        DefaultMQProducerImpl.this.log.error("Broker call checkTransactionState, but checkLocalTransactionState exception", e);
                        exception = e;
                    }
                    this.processTransactionState(localTransactionState, this.group, exception);
                } else {
                    DefaultMQProducerImpl.this.log.warn("checkTransactionState, pick transactionCheckListener by group[{}] failed", (Object)this.group);
                }
            }

            private void processTransactionState(LocalTransactionState localTransactionState, String producerGroup, Throwable exception) {
                EndTransactionRequestHeader thisHeader = new EndTransactionRequestHeader();
                thisHeader.setCommitLogOffset(this.checkRequestHeader.getCommitLogOffset());
                thisHeader.setProducerGroup(producerGroup);
                thisHeader.setTranStateTableOffset(this.checkRequestHeader.getTranStateTableOffset());
                thisHeader.setFromTransactionCheck(Boolean.valueOf(true));
                thisHeader.setMsgId(this.message.getMsgId());
                thisHeader.setTransactionId(this.checkRequestHeader.getTransactionId());
                switch (localTransactionState) {
                    case COMMIT_MESSAGE: {
                        thisHeader.setCommitOrRollback(Integer.valueOf(8));
                        break;
                    }
                    case ROLLBACK_MESSAGE: {
                        thisHeader.setCommitOrRollback(Integer.valueOf(12));
                        DefaultMQProducerImpl.this.log.warn("when broker check, client rollback this transaction, {}", (Object)thisHeader);
                        break;
                    }
                    case UNKNOW: {
                        thisHeader.setCommitOrRollback(Integer.valueOf(0));
                        DefaultMQProducerImpl.this.log.warn("when broker check, client donot know this transaction state, {}", (Object)thisHeader);
                        break;
                    }
                }
                String remark = null;
                if (exception != null) {
                    remark = "checkLocalTransactionState Exception: " + RemotingHelper.exceptionSimpleDesc((Throwable)exception);
                }
                try {
                    DefaultMQProducerImpl.this.mQClientFactory.getMQClientAPIImpl().endTransactionOneway(this.brokerAddr, thisHeader, remark, 3000L);
                }
                catch (Exception e) {
                    DefaultMQProducerImpl.this.log.error("endTransactionOneway exception", (Throwable)e);
                }
            }
        };
        this.checkExecutor.submit(request);
    }

    @Override
    public void updateTopicPublishInfo(String topic, TopicPublishInfo info) {
        TopicPublishInfo prev;
        if (info != null && topic != null && (prev = this.topicPublishInfoTable.put(topic, info)) != null) {
            info.getSendWhichQueue().set(prev.getSendWhichQueue().get());
            this.log.info("updateTopicPublishInfo prev is not null, " + prev.toString());
        }
    }

    @Override
    public boolean isUnitMode() {
        return this.defaultMQProducer.isUnitMode();
    }

    public void createTopic(String key, String newTopic, int queueNum) throws MQClientException {
        this.createTopic(key, newTopic, queueNum, 0);
    }

    public void createTopic(String key, String newTopic, int queueNum, int topicSysFlag) throws MQClientException {
        this.makeSureStateOK();
        Validators.checkTopic(newTopic);
        this.mQClientFactory.getMQAdminImpl().createTopic(key, newTopic, queueNum, topicSysFlag);
    }

    private void makeSureStateOK() throws MQClientException {
        if (this.serviceState != ServiceState.RUNNING) {
            throw new MQClientException("The producer service state not OK, " + this.serviceState + FAQUrl.suggestTodo((String)"http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&service_not_ok"), null);
        }
    }

    public List<MessageQueue> fetchPublishMessageQueues(String topic) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().fetchPublishMessageQueues(topic);
    }

    public long searchOffset(MessageQueue mq, long timestamp) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().searchOffset(mq, timestamp);
    }

    public long maxOffset(MessageQueue mq) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().maxOffset(mq);
    }

    public long minOffset(MessageQueue mq) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().minOffset(mq);
    }

    public long earliestMsgStoreTime(MessageQueue mq) throws MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().earliestMsgStoreTime(mq);
    }

    public MessageExt viewMessage(String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().viewMessage(msgId);
    }

    public QueryResult queryMessage(String topic, String key, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().queryMessage(topic, key, maxNum, begin, end);
    }

    public void send(Message msg, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        this.send(msg, sendCallback, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public void send(Message msg, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, InterruptedException {
        try {
            this.sendDefaultImpl(msg, CommunicationMode.ASYNC, sendCallback, timeout);
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknown exception", e);
        }
    }

    private SendResult sendDefaultImpl(Message msg, CommunicationMode communicationMode, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        long beginTimestamp;
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        long maxTimeout = this.defaultMQProducer.getSendMsgTimeout() + 1000;
        long endTimestamp = beginTimestamp = System.currentTimeMillis();
        TopicPublishInfo topicPublishInfo = this.tryToFindTopicPublishInfo(msg.getTopic());
        if (topicPublishInfo != null && topicPublishInfo.ok()) {
            String lastBrokerName;
            MessageQueue tmpmq;
            int times;
            MessageQueue mq = null;
            Throwable exception = null;
            SendResult sendResult = null;
            int timesTotal = 1 + this.defaultMQProducer.getRetryTimesWhenSendFailed();
            Object[] brokersSent = new String[timesTotal];
            block13: for (times = 0; times < timesTotal && endTimestamp - beginTimestamp < maxTimeout && (tmpmq = topicPublishInfo.selectOneMessageQueue(lastBrokerName = null == mq ? null : mq.getBrokerName())) != null; ++times) {
                mq = tmpmq;
                brokersSent[times] = mq.getBrokerName();
                try {
                    sendResult = this.sendKernelImpl(msg, mq, communicationMode, sendCallback, timeout);
                    endTimestamp = System.currentTimeMillis();
                    switch (communicationMode) {
                        case ASYNC: {
                            return null;
                        }
                        case ONEWAY: {
                            return null;
                        }
                        case SYNC: {
                            if (sendResult.getSendStatus() != SendStatus.SEND_OK && this.defaultMQProducer.isRetryAnotherBrokerWhenNotStoreOK()) break;
                            return sendResult;
                        }
                    }
                    continue;
                }
                catch (RemotingException e) {
                    this.log.warn("sendKernelImpl exception", (Throwable)e);
                    this.log.warn(msg.toString());
                    exception = e;
                    endTimestamp = System.currentTimeMillis();
                    continue;
                }
                catch (MQClientException e) {
                    this.log.warn("sendKernelImpl exception", (Throwable)e);
                    this.log.warn(msg.toString());
                    exception = e;
                    endTimestamp = System.currentTimeMillis();
                    continue;
                }
                catch (MQBrokerException e) {
                    this.log.warn("sendKernelImpl exception", (Throwable)e);
                    this.log.warn(msg.toString());
                    exception = e;
                    endTimestamp = System.currentTimeMillis();
                    switch (e.getResponseCode()) {
                        case 1: 
                        case 14: 
                        case 16: 
                        case 17: 
                        case 204: 
                        case 205: {
                            continue block13;
                        }
                        default: {
                            if (sendResult != null) {
                                return sendResult;
                            }
                            throw e;
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.log.warn("sendKernelImpl exception", (Throwable)e);
                    this.log.warn(msg.toString());
                    throw e;
                }
            }
            if (sendResult != null) {
                return sendResult;
            }
            String info = String.format("Send [%d] times, still failed, cost [%d]ms, Topic: %s, BrokersSent: %s", times, System.currentTimeMillis() - beginTimestamp, msg.getTopic(), Arrays.toString(brokersSent));
            info = info + FAQUrl.suggestTodo((String)"http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&send_msg_failed");
            throw new MQClientException(info, exception);
        }
        List<String> nsList = this.getmQClientFactory().getMQClientAPIImpl().getNameServerAddressList();
        if (null == nsList || nsList.isEmpty()) {
            throw new MQClientException("No name server address, please set it." + FAQUrl.suggestTodo((String)"http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&namesrv_not_exist"), null);
        }
        throw new MQClientException("No route info of this topic, " + msg.getTopic() + FAQUrl.suggestTodo((String)"http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&topic_not_exist"), null);
    }

    private TopicPublishInfo tryToFindTopicPublishInfo(String topic) {
        TopicPublishInfo topicPublishInfo = this.topicPublishInfoTable.get(topic);
        if (null == topicPublishInfo || !topicPublishInfo.ok()) {
            this.topicPublishInfoTable.putIfAbsent(topic, new TopicPublishInfo());
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(topic);
            topicPublishInfo = this.topicPublishInfoTable.get(topic);
        }
        if (topicPublishInfo.isHaveTopicRouterInfo() || topicPublishInfo != null && topicPublishInfo.ok()) {
            return topicPublishInfo;
        }
        this.mQClientFactory.updateTopicRouteInfoFromNameServer(topic, true, this.defaultMQProducer);
        topicPublishInfo = this.topicPublishInfoTable.get(topic);
        return topicPublishInfo;
    }

    private SendResult sendKernelImpl(Message msg, MessageQueue mq, CommunicationMode communicationMode, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        if (null == brokerAddr) {
            this.tryToFindTopicPublishInfo(mq.getTopic());
            brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(mq.getBrokerName());
        }
        SendMessageContext context = null;
        if (brokerAddr != null) {
            if (this.defaultMQProducer.isSendMessageWithVIPChannel()) {
                brokerAddr = MixAll.brokerVIPChannel((String)brokerAddr);
            }
            byte[] prevBody = msg.getBody();
            try {
                String reconsumeTimes;
                String tranMsg;
                int sysFlag = 0;
                if (this.tryToCompressMessage(msg)) {
                    sysFlag |= 1;
                }
                if ((tranMsg = msg.getProperty("TRAN_MSG")) != null && Boolean.parseBoolean(tranMsg)) {
                    sysFlag |= 4;
                }
                if (this.hasCheckForbiddenHook()) {
                    CheckForbiddenContext checkForbiddenContext = new CheckForbiddenContext();
                    checkForbiddenContext.setNameSrvAddr(this.defaultMQProducer.getNamesrvAddr());
                    checkForbiddenContext.setGroup(this.defaultMQProducer.getProducerGroup());
                    checkForbiddenContext.setCommunicationMode(communicationMode);
                    checkForbiddenContext.setBrokerAddr(brokerAddr);
                    checkForbiddenContext.setMessage(msg);
                    checkForbiddenContext.setMq(mq);
                    checkForbiddenContext.setUnitMode(this.isUnitMode());
                    this.executeCheckForbiddenHook(checkForbiddenContext);
                }
                if (this.hasSendMessageHook()) {
                    context = new SendMessageContext();
                    context.setProducerGroup(this.defaultMQProducer.getProducerGroup());
                    context.setCommunicationMode(communicationMode);
                    context.setBornHost(this.defaultMQProducer.getClientIP());
                    context.setBrokerAddr(brokerAddr);
                    context.setMessage(msg);
                    context.setMq(mq);
                    this.executeSendMessageHookBefore(context);
                }
                SendMessageRequestHeader requestHeader = new SendMessageRequestHeader();
                requestHeader.setProducerGroup(this.defaultMQProducer.getProducerGroup());
                requestHeader.setTopic(msg.getTopic());
                requestHeader.setDefaultTopic(this.defaultMQProducer.getCreateTopicKey());
                requestHeader.setDefaultTopicQueueNums(Integer.valueOf(this.defaultMQProducer.getDefaultTopicQueueNums()));
                requestHeader.setQueueId(Integer.valueOf(mq.getQueueId()));
                requestHeader.setSysFlag(Integer.valueOf(sysFlag));
                requestHeader.setBornTimestamp(Long.valueOf(System.currentTimeMillis()));
                requestHeader.setFlag(Integer.valueOf(msg.getFlag()));
                requestHeader.setProperties(MessageDecoder.messageProperties2String((Map)msg.getProperties()));
                requestHeader.setReconsumeTimes(Integer.valueOf(0));
                requestHeader.setUnitMode(this.isUnitMode());
                if (requestHeader.getTopic().startsWith("%RETRY%") && (reconsumeTimes = MessageAccessor.getReconsumeTime((Message)msg)) != null) {
                    requestHeader.setReconsumeTimes(new Integer(reconsumeTimes));
                    MessageAccessor.clearProperty((Message)msg, (String)"RECONSUME_TIME");
                }
                SendResult sendResult = this.mQClientFactory.getMQClientAPIImpl().sendMessage(brokerAddr, mq.getBrokerName(), msg, requestHeader, timeout, communicationMode, sendCallback);
                if (this.hasSendMessageHook()) {
                    context.setSendResult(sendResult);
                    this.executeSendMessageHookAfter(context);
                }
                SendResult sendResult2 = sendResult;
                return sendResult2;
            }
            catch (RemotingException e) {
                if (this.hasSendMessageHook()) {
                    context.setException((Exception)((Object)e));
                    this.executeSendMessageHookAfter(context);
                }
                throw e;
            }
            catch (MQBrokerException e) {
                if (this.hasSendMessageHook()) {
                    context.setException(e);
                    this.executeSendMessageHookAfter(context);
                }
                throw e;
            }
            catch (InterruptedException e) {
                if (this.hasSendMessageHook()) {
                    context.setException(e);
                    this.executeSendMessageHookAfter(context);
                }
                throw e;
            }
            finally {
                msg.setBody(prevBody);
            }
        }
        throw new MQClientException("The broker[" + mq.getBrokerName() + "] not exist", null);
    }

    private boolean tryToCompressMessage(Message msg) {
        byte[] body = msg.getBody();
        if (body != null && body.length >= this.defaultMQProducer.getCompressMsgBodyOverHowmuch()) {
            try {
                byte[] data = UtilAll.compress((byte[])body, (int)this.zipCompressLevel);
                if (data != null) {
                    msg.setBody(data);
                    return true;
                }
            }
            catch (IOException e) {
                this.log.error("tryToCompressMessage exception", (Throwable)e);
                this.log.warn(msg.toString());
            }
        }
        return false;
    }

    public void sendOneway(Message msg) throws MQClientException, RemotingException, InterruptedException {
        try {
            this.sendDefaultImpl(msg, CommunicationMode.ONEWAY, null, this.defaultMQProducer.getSendMsgTimeout());
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknow exception", e);
        }
    }

    public SendResult send(Message msg, MessageQueue mq) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.send(msg, mq, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public SendResult send(Message msg, MessageQueue mq, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        if (!msg.getTopic().equals(mq.getTopic())) {
            throw new MQClientException("message's topic not equal mq's topic", null);
        }
        return this.sendKernelImpl(msg, mq, CommunicationMode.SYNC, null, timeout);
    }

    public void send(Message msg, MessageQueue mq, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        this.send(msg, mq, sendCallback, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public void send(Message msg, MessageQueue mq, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, InterruptedException {
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        if (!msg.getTopic().equals(mq.getTopic())) {
            throw new MQClientException("message's topic not equal mq's topic", null);
        }
        try {
            this.sendKernelImpl(msg, mq, CommunicationMode.ASYNC, sendCallback, timeout);
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknow exception", e);
        }
    }

    public void sendOneway(Message msg, MessageQueue mq) throws MQClientException, RemotingException, InterruptedException {
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        try {
            this.sendKernelImpl(msg, mq, CommunicationMode.ONEWAY, null, this.defaultMQProducer.getSendMsgTimeout());
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknow exception", e);
        }
    }

    public SendResult send(Message msg, MessageQueueSelector selector, Object arg) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.send(msg, selector, arg, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public SendResult send(Message msg, MessageQueueSelector selector, Object arg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.sendSelectImpl(msg, selector, arg, CommunicationMode.SYNC, null, timeout);
    }

    private SendResult sendSelectImpl(Message msg, MessageQueueSelector selector, Object arg, CommunicationMode communicationMode, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        this.makeSureStateOK();
        Validators.checkMessage(msg, this.defaultMQProducer);
        TopicPublishInfo topicPublishInfo = this.tryToFindTopicPublishInfo(msg.getTopic());
        if (topicPublishInfo != null && topicPublishInfo.ok()) {
            MessageQueue mq = null;
            try {
                mq = selector.select(topicPublishInfo.getMessageQueueList(), msg, arg);
            }
            catch (Throwable e) {
                throw new MQClientException("select message queue throwed exception.", e);
            }
            if (mq != null) {
                return this.sendKernelImpl(msg, mq, communicationMode, sendCallback, timeout);
            }
            throw new MQClientException("select message queue return null.", null);
        }
        throw new MQClientException("No route info for this topic, " + msg.getTopic(), null);
    }

    public void send(Message msg, MessageQueueSelector selector, Object arg, SendCallback sendCallback) throws MQClientException, RemotingException, InterruptedException {
        this.send(msg, selector, arg, sendCallback, this.defaultMQProducer.getSendMsgTimeout());
    }

    public void send(Message msg, MessageQueueSelector selector, Object arg, SendCallback sendCallback, long timeout) throws MQClientException, RemotingException, InterruptedException {
        try {
            this.sendSelectImpl(msg, selector, arg, CommunicationMode.ASYNC, sendCallback, timeout);
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknown exception", e);
        }
    }

    public void sendOneway(Message msg, MessageQueueSelector selector, Object arg) throws MQClientException, RemotingException, InterruptedException {
        try {
            this.sendSelectImpl(msg, selector, arg, CommunicationMode.ONEWAY, null, this.defaultMQProducer.getSendMsgTimeout());
        }
        catch (MQBrokerException e) {
            throw new MQClientException("unknow exception", e);
        }
    }

    public TransactionSendResult sendMessageInTransaction(Message msg, LocalTransactionExecuter tranExecuter, Object arg) throws MQClientException {
        if (null == tranExecuter) {
            throw new MQClientException("tranExecutor is null", null);
        }
        Validators.checkMessage(msg, this.defaultMQProducer);
        SendResult sendResult = null;
        MessageAccessor.putProperty((Message)msg, (String)"TRAN_MSG", (String)"true");
        MessageAccessor.putProperty((Message)msg, (String)"PGROUP", (String)this.defaultMQProducer.getProducerGroup());
        try {
            sendResult = this.send(msg);
        }
        catch (Exception e) {
            throw new MQClientException("send message Exception", e);
        }
        LocalTransactionState localTransactionState = LocalTransactionState.UNKNOW;
        Throwable localException = null;
        switch (sendResult.getSendStatus()) {
            case SEND_OK: {
                try {
                    if (sendResult.getTransactionId() != null) {
                        msg.putUserProperty("__transactionId__", sendResult.getTransactionId());
                    }
                    if (null == (localTransactionState = tranExecuter.executeLocalTransactionBranch(msg, arg))) {
                        localTransactionState = LocalTransactionState.UNKNOW;
                    }
                    if (localTransactionState == LocalTransactionState.COMMIT_MESSAGE) break;
                    this.log.info("executeLocalTransactionBranch return {}", (Object)localTransactionState);
                    this.log.info(msg.toString());
                }
                catch (Throwable e) {
                    this.log.info("executeLocalTransactionBranch exception", e);
                    this.log.info(msg.toString());
                    localException = e;
                }
                break;
            }
            case FLUSH_DISK_TIMEOUT: 
            case FLUSH_SLAVE_TIMEOUT: 
            case SLAVE_NOT_AVAILABLE: {
                localTransactionState = LocalTransactionState.ROLLBACK_MESSAGE;
                break;
            }
        }
        try {
            this.endTransaction(sendResult, localTransactionState, localException);
        }
        catch (Exception e) {
            this.log.warn("local transaction execute " + (Object)((Object)localTransactionState) + ", but end broker transaction failed", (Throwable)e);
        }
        TransactionSendResult transactionSendResult = new TransactionSendResult();
        transactionSendResult.setSendStatus(sendResult.getSendStatus());
        transactionSendResult.setMessageQueue(sendResult.getMessageQueue());
        transactionSendResult.setMsgId(sendResult.getMsgId());
        transactionSendResult.setQueueOffset(sendResult.getQueueOffset());
        transactionSendResult.setTransactionId(sendResult.getTransactionId());
        transactionSendResult.setLocalTransactionState(localTransactionState);
        return transactionSendResult;
    }

    private void endTransaction(SendResult sendResult, LocalTransactionState localTransactionState, Throwable localException) throws RemotingException, MQBrokerException, InterruptedException, UnknownHostException {
        MessageId id = MessageDecoder.decodeMessageId((String)sendResult.getMsgId());
        String transactionId = sendResult.getTransactionId();
        String brokerAddr = this.mQClientFactory.findBrokerAddressInPublish(sendResult.getMessageQueue().getBrokerName());
        EndTransactionRequestHeader requestHeader = new EndTransactionRequestHeader();
        requestHeader.setTransactionId(transactionId);
        requestHeader.setCommitLogOffset(Long.valueOf(id.getOffset()));
        switch (localTransactionState) {
            case COMMIT_MESSAGE: {
                requestHeader.setCommitOrRollback(Integer.valueOf(8));
                break;
            }
            case ROLLBACK_MESSAGE: {
                requestHeader.setCommitOrRollback(Integer.valueOf(12));
                break;
            }
            case UNKNOW: {
                requestHeader.setCommitOrRollback(Integer.valueOf(0));
                break;
            }
        }
        requestHeader.setProducerGroup(this.defaultMQProducer.getProducerGroup());
        requestHeader.setTranStateTableOffset(Long.valueOf(sendResult.getQueueOffset()));
        requestHeader.setMsgId(sendResult.getMsgId());
        String remark = localException != null ? "executeLocalTransactionBranch exception: " + localException.toString() : null;
        this.mQClientFactory.getMQClientAPIImpl().endTransactionOneway(brokerAddr, requestHeader, remark, this.defaultMQProducer.getSendMsgTimeout());
    }

    public SendResult send(Message msg) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.send(msg, this.defaultMQProducer.getSendMsgTimeout());
    }

    public SendResult send(Message msg, long timeout) throws MQClientException, RemotingException, MQBrokerException, InterruptedException {
        return this.sendDefaultImpl(msg, CommunicationMode.SYNC, null, timeout);
    }

    public ConcurrentHashMap<String, TopicPublishInfo> getTopicPublishInfoTable() {
        return this.topicPublishInfoTable;
    }

    public MQClientInstance getmQClientFactory() {
        return this.mQClientFactory;
    }

    public int getZipCompressLevel() {
        return this.zipCompressLevel;
    }

    public void setZipCompressLevel(int zipCompressLevel) {
        this.zipCompressLevel = zipCompressLevel;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    public void setServiceState(ServiceState serviceState) {
        this.serviceState = serviceState;
    }
}

