/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.common.tool;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import com.aliyun.api.AliyunRequest;
import com.aliyun.api.DefaultAliyunClient;
import com.aliyun.api.cdn.cdn20141111.request.RefreshObjectCachesRequest;
import com.aliyun.api.cdn.cdn20141111.response.RefreshObjectCachesResponse;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.ObjectMetadata;
import com.taobao.api.ApiException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class UploadTool {
    private static Logger LOGGER = LoggerFactory.getLogger(UploadTool.class);
    private static String accessId;
    private static String accessKey;
    private static String endPoint;
    private static String bucketName;
    private static String serverUrl;
    private static String objectPath;
    private static String tuiaUrl;

    public static void uploadOss(File file, String objectName) throws TuiaMediaException {
        UploadTool.uploadOss(file, objectName, null);
    }

    private static void uploadOss(File file, String objectName, String contentType) throws TuiaMediaException {
        OSSClient clientOss = new OSSClient(endPoint, accessId, accessKey);
        if (clientOss.doesBucketExist(bucketName)) {
            FileInputStream content = null;
            try {
                content = new FileInputStream(file);
                ObjectMetadata meta = new ObjectMetadata();
                meta.setContentLength(file.length());
                if (null != contentType) {
                    meta.setContentType(contentType);
                }
                boolean flag = false;
                if (UploadTool.isFileExist(objectName)) {
                    flag = true;
                }
                clientOss.putObject(bucketName, objectName, (InputStream)content, meta);
                if (flag) {
                    UploadTool.refreshObjectCaches(objectName);
                }
            }
            catch (OSSException e) {
                LOGGER.error("oss upload happen OSSException!", (Throwable)e);
                throw new TuiaMediaException(ErrorCode.E0003003, (Throwable)e);
            }
            catch (ClientException e) {
                LOGGER.error("oss upload happen ClientException!", (Throwable)e);
                throw new TuiaMediaException(ErrorCode.E0003003, (Throwable)e);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("oss upload file error! beacuse the file[{}] not found", (Object)file, (Object)e);
                throw new TuiaMediaException(ErrorCode.E0003003, (Throwable)e);
            }
            finally {
                if (content != null) {
                    try {
                        ((InputStream)content).close();
                    }
                    catch (IOException e) {
                        LOGGER.error("oss upload file happen IOException", (Throwable)e);
                    }
                }
            }
        }
    }

    public static void uploadOssCss(File file, String objectName) throws TuiaMediaException {
        UploadTool.uploadOss(file, objectName, "text/css");
    }

    public static void uploadOssJs(File file, String objectName) throws TuiaMediaException {
        UploadTool.uploadOss(file, objectName, "text/js");
    }

    public static void uploadOssImg(File file, String objectName) throws TuiaMediaException {
        UploadTool.uploadOss(file, objectName, "image/jpeg");
    }

    public static void uploadOssImg(InputStream content, String objectName, long size) throws TuiaMediaException {
        UploadTool.uploadOss(content, objectName, size, "image/jpeg");
    }

    public static void uploadOss(InputStream content, String objectName, long size) throws TuiaMediaException {
        UploadTool.uploadOss(content, objectName, size, null);
    }

    private static void uploadOss(InputStream content, String objectName, long size, String contentType) throws TuiaMediaException {
        OSSClient clientOss = new OSSClient(endPoint, accessId, accessKey);
        if (clientOss.doesBucketExist(bucketName)) {
            try {
                ObjectMetadata meta = new ObjectMetadata();
                meta.setContentLength(size);
                if (null != contentType) {
                    meta.setContentType(contentType);
                }
                boolean flag = false;
                if (UploadTool.isFileExist(objectName)) {
                    flag = true;
                }
                clientOss.putObject(bucketName, objectName, content, meta);
                if (flag) {
                    UploadTool.refreshObjectCaches(objectName);
                }
            }
            catch (OSSException e) {
                LOGGER.error("oss upload file happen OSSException!", (Throwable)e);
                throw new TuiaMediaException(ErrorCode.E0003003, (Throwable)e);
            }
            catch (ClientException e) {
                LOGGER.error("oss upload file happen ClientException!", (Throwable)e);
                throw new TuiaMediaException(ErrorCode.E0003003, (Throwable)e);
            }
        }
    }

    public static void refreshObjectCaches(String path) throws TuiaMediaException {
        DefaultAliyunClient clientCdn = new DefaultAliyunClient(serverUrl, accessId, accessKey);
        RefreshObjectCachesRequest request = new RefreshObjectCachesRequest();
        request.setObjectType(ObjectType.File.name());
        request.setObjectPath(objectPath + path);
        try {
            RefreshObjectCachesResponse response = (RefreshObjectCachesResponse)clientCdn.execute((AliyunRequest)request);
            if (!StringUtils.isEmpty((Object)response.getErrorCode())) {
                LOGGER.error("refresh caches error! the path=[{}] and the message=[{}]", (Object)path, (Object)response.getMessage());
                throw new TuiaMediaException(ErrorCode.E0003003);
            }
        }
        catch (ApiException e) {
            LOGGER.error("refresh caches happen ApiException! the path is:" + path, (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0003003, (Throwable)e);
        }
    }

    public static boolean isFileExist(String objectName) {
        OSSClient clientOss = new OSSClient(endPoint, accessId, accessKey);
        try {
            clientOss.getObject(bucketName, objectName);
            return true;
        }
        catch (ClientException e) {
            LOGGER.error("oss upload file happen ClientException", (Throwable)e);
            return false;
        }
        catch (OSSException e) {
            LOGGER.error("oss upload file happen OSSException", (Object)e.getMessage());
            return false;
        }
    }

    public void deleteObject(String objectName) {
        OSSClient clientOss = new OSSClient(endPoint, accessId, accessKey);
        try {
            clientOss.deleteObject(bucketName, objectName);
        }
        catch (OSSException e) {
            LOGGER.error("deleteObject happen OSSException! the objectName=[{}]", (Object)objectName, (Object)e);
        }
        catch (ClientException e) {
            LOGGER.error("deleteObject happen ClientException! the objectName=[{}]", (Object)objectName, (Object)e);
        }
    }

    public static void setAccessId(String accessId) {
        UploadTool.accessId = accessId;
    }

    public static void setAccessKey(String accessKey) {
        UploadTool.accessKey = accessKey;
    }

    public static void setEndPoint(String endPoint) {
        UploadTool.endPoint = endPoint;
    }

    public static void setBucketName(String bucketName) {
        UploadTool.bucketName = bucketName;
    }

    public static void setServerUrl(String serverUrl) {
        UploadTool.serverUrl = serverUrl;
    }

    public static void setObjectPath(String objectPath) {
        UploadTool.objectPath = objectPath;
    }

    public static String getTuiaUrl() {
        return tuiaUrl;
    }

    public static void setTuiaUrl(String tuiaUrl) {
        UploadTool.tuiaUrl = tuiaUrl;
    }

    static enum ObjectType {
        File,
        Directory;

    }
}

