/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.api.dto.DataStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.SlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dao.SlotStatisticsDAO;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class SlotStatisticsDAOImpl
extends BaseDAO
implements SlotStatisticsDAO {
    @Override
    public int selectSlotDataAmout(ReqSlotStatisticsDto req, List<Long> slotIdsList, List<Long> appIdsList) throws TuiaMediaException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(3);
            param.put("req", req);
            param.put("slotIdsList", slotIdsList);
            param.put("appIdsList", appIdsList);
            return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("selectSlotDataAmout"), param);
        }
        catch (Exception e) {
            this.logger.error("SlotStatisticsDAOImpl.selectSlotDataAmout data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<SlotStatisticsDto> selectListSlotDataByPage(ReqSlotStatisticsDto req, List<Long> slotIdsList, List<Long> appIdsList) throws TuiaMediaException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(3);
            param.put("req", req);
            param.put("slotIdsList", slotIdsList);
            param.put("appIdsList", appIdsList);
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectListSlotDataByPage"), param);
        }
        catch (Exception e) {
            this.logger.error("SlotStatisticsDAOImpl.selectListSlotDataByPage data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int selectMediaDataAmount(ReqMediaAppStatisticsDto req, List<Long> appIdsList) throws TuiaMediaException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("req", req);
            param.put("appIdsList", appIdsList);
            return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("selectMediaDataAmount"), param);
        }
        catch (Exception e) {
            this.logger.error("SlotStatisticsDAOImpl.selectMediaDataAmount data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<MediaAppStatisticsDto> selectListMediaDataByPage(ReqMediaAppStatisticsDto req, List<Long> appIdsList) throws TuiaMediaException {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("req", req);
            param.put("appIdsList", appIdsList);
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectListMediaDataByPage"), param);
        }
        catch (Exception e) {
            this.logger.error("SlotStatisticsDAOImpl.selectListMediaDataByPage data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<DataStatisticsDto> selectByDate(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectByDate"), (Object)param);
        }
        catch (Exception e) {
            this.logger.error("the SlotStatisticsDAOImpl.selectByDate data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
    }
}

