/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.message.consumer;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.message.MessageBody.AdActivityMessage;
import cn.com.duiba.tuia.media.message.consumer.AbstractKafkaConsumer;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.utils.JsonUtils;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ActivityKafkaConsumer
extends AbstractKafkaConsumer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ActivityService activityService;
    @Value(value="${media.kafka.activity.topic}")
    private String topic;

    @Override
    protected List<String> getTopics() {
        return Arrays.asList(this.topic);
    }

    @Override
    protected void readMessage(ConsumerRecord<String, String> record) {
        String message = (String)record.value();
        AdActivityMessage adActivityMessage = JsonUtils.jsonToObject(AdActivityMessage.class, message);
        if (adActivityMessage != null) {
            try {
                switch (adActivityMessage.getAction()) {
                    case "insert": {
                        ActivityDto activityDto = new ActivityDto();
                        activityDto.setActivityId(adActivityMessage.getActivityId());
                        activityDto.setActivityStatus(adActivityMessage.getActivityStatus());
                        activityDto.setActivityType(adActivityMessage.getActivityType());
                        activityDto.setActivityName(adActivityMessage.getActivityName());
                        activityDto.setTag(adActivityMessage.getTag());
                        this.activityService.insertActivity(Lists.newArrayList((Object[])new ActivityDto[]{activityDto}));
                        break;
                    }
                    case "update": {
                        ActivityDto activityDto = this.activityService.selectByActivityIdAndType(adActivityMessage.getActivityId(), adActivityMessage.getActivityType());
                        if (activityDto == null) {
                            throw new TuiaMediaException(ErrorCode.E0501001);
                        }
                        if (adActivityMessage.getActivityStatus() != null) {
                            activityDto.setActivityStatus(adActivityMessage.getActivityStatus());
                        }
                        if (adActivityMessage.getActivityType() != null) {
                            activityDto.setActivityType(adActivityMessage.getActivityType());
                        }
                        if (adActivityMessage.getActivityName() != null) {
                            activityDto.setActivityName(adActivityMessage.getActivityName());
                        }
                        if (adActivityMessage.getTag() != null) {
                            activityDto.setTag(adActivityMessage.getTag());
                        }
                        this.activityService.updateActivity(activityDto);
                        break;
                    }
                    case "delete": {
                        ActivityDto activityDto = this.activityService.selectByActivityIdAndType(adActivityMessage.getActivityId(), adActivityMessage.getActivityType());
                        if (activityDto == null) {
                            throw new TuiaMediaException(ErrorCode.E0501001);
                        }
                        activityDto.setDelete(1);
                        this.activityService.updateActivity(activityDto);
                        break;
                    }
                }
            }
            catch (TuiaMediaException e) {
                this.log.error("ActivityKafkaConsumer error:", (Throwable)e);
            }
        }
    }
}

