/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivitySortBackendService;
import cn.com.duiba.tuia.media.common.constants.ActivityTypeConstant;
import cn.com.duiba.tuia.media.common.tool.DataTool;
import cn.com.duiba.tuia.media.common.utils.CollectionUtil;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.domain.ActivityStatisticsDayDto;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.ActivityStatisticsDayService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteActivitySortBackendServiceImpl
extends BaseRemoteService
implements RemoteActivitySortBackendService {
    private static final long TIME_DIFFER = 1000000L;
    @Autowired
    private ActivitySortService activitySortService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityStatisticsDayService activityStatisticsDayService;

    public DubboResult<PageResultDto<RspActivityDto>> getByCondition(ReqActivitySort reqActivitySort) {
        try {
            List<ActivitySortDto> result = this.activitySortService.selectByCondition(reqActivitySort);
            if (result == null || result.size() == 0) {
                return DubboResult.successResult((Object)new PageResultDto(0, new ArrayList(), reqActivitySort.getPageSize().intValue()));
            }
            List<ActivityDto> activityDtoList = this.activityService.selectByActivityIds(CollectionUtil.getFieldList(result, (String)"activityId"));
            HashMap<Long, ActivityDto> activityMap = new HashMap<Long, ActivityDto>(activityDtoList.size());
            for (ActivityDto activityDto : activityDtoList) {
                activityMap.put(activityDto.getActivityId(), activityDto);
            }
            ArrayList<RspActivityDto> rspActivityDtoList = new ArrayList<RspActivityDto>(result.size());
            List<ActivityStatisticsDayDto> activityStatisticsDayDtoList = this.activityStatisticsDayService.selectExposureAndLaunchAdvert(CollectionUtil.getFieldList(result, (String)"activityId"), reqActivitySort.getAppId());
            HashMap<Long, Long> spmMap = new HashMap<Long, Long>(activityStatisticsDayDtoList.size());
            for (ActivityStatisticsDayDto activityStatisticsDayDto : activityStatisticsDayDtoList) {
                spmMap.put(activityStatisticsDayDto.getDuibaActivityId(), DataTool.calculateEcpm((Long)activityStatisticsDayDto.getLaunchAdvertCount(), (Long)activityStatisticsDayDto.getExposureCount()));
            }
            for (ActivitySortDto activitySortDto : result) {
                RspActivityDto rspActivityDto = new RspActivityDto();
                rspActivityDto.setId(Long.valueOf(activitySortDto.getActivityId()));
                if (activityMap.get(activitySortDto.getActivityId()) != null) {
                    rspActivityDto.setName(((ActivityDto)((Object)activityMap.get(activitySortDto.getActivityId()))).getActivityName());
                    rspActivityDto.setDelete(Boolean.valueOf(((ActivityDto)((Object)activityMap.get(activitySortDto.getActivityId()))).getDelete().equals(1)));
                    rspActivityDto.setType(((ActivityDto)((Object)activityMap.get(activitySortDto.getActivityId()))).getActivityType());
                    rspActivityDto.setTypeName(ActivityTypeConstant.getTypeText((Integer)((ActivityDto)((Object)activityMap.get(activitySortDto.getActivityId()))).getActivityType()));
                    rspActivityDto.setSpm((Long)spmMap.get(activitySortDto.getActivityId()));
                }
                rspActivityDtoList.add(rspActivityDto);
            }
            return DubboResult.successResult((Object)new PageResultDto(this.activitySortService.selectByConditionAmount(reqActivitySort), rspActivityDtoList, reqActivitySort.getPageSize().intValue()));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.getByCondition is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> addActivitySort(Long activityAppId, List<Long> activityIds) {
        try {
            Long sort = new Date().getTime();
            ActivitySortDto result = this.activitySortService.getMaxSortValueActivitySortDto(activityAppId);
            if (result != null && result.getActivitySort() >= sort) {
                sort = result.getActivitySort() + 1000000L;
            }
            ReqActivitySort reqActivitySort = new ReqActivitySort();
            reqActivitySort.setAppId(activityAppId);
            List<ActivitySortDto> existList = this.activitySortService.selectByCondition(reqActivitySort);
            HashMap<Long, Long> map = new HashMap<Long, Long>(existList.size());
            for (ActivitySortDto activitySortDto : existList) {
                map.put(activitySortDto.getActivityId() + (long)activitySortDto.getActivityType().intValue(), activitySortDto.getActivitySort());
            }
            List<ActivityDto> activityDtoList = this.activityService.selectByActivityIds(activityIds);
            ArrayList<ActivitySortDto> activitySortDtoList = new ArrayList<ActivitySortDto>();
            for (ActivityDto activityDto : activityDtoList) {
                if (map.get(activityDto.getActivityId() + (long)activityDto.getActivityType().intValue()) != null) continue;
                ActivitySortDto activitySortDto = new ActivitySortDto();
                activitySortDto.setActivityAppId(activityAppId);
                activitySortDto.setActivityId(activityDto.getActivityId());
                activitySortDto.setActivitySort(sort);
                sort = sort + 1000000L;
                activitySortDtoList.add(activitySortDto);
            }
            if (activitySortDtoList.size() > 0) {
                this.activitySortService.insertBatchActivitySort(activitySortDtoList);
            }
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.addActivitySort is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> addDefaultActivitySort(Long activityAppId) {
        ArrayList<Long> defaultIds = new ArrayList<Long>();
        try {
            ReqActivitySort reqActivitySort = new ReqActivitySort();
            reqActivitySort.setAppId(Long.valueOf(0L));
            List<ActivitySortDto> defaultList = this.activitySortService.selectByCondition(reqActivitySort);
            for (ActivitySortDto activitySortDto : defaultList) {
                defaultIds.add(activitySortDto.getActivityId());
            }
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.addDefaultActivitySort is error");
            return this.exceptionFailure(e);
        }
        return this.addActivitySort(activityAppId, defaultIds);
    }

    public DubboResult<Boolean> removeActivity(Long activityAppId, Long activityId, Integer activityType) {
        try {
            return DubboResult.successResult((Object)this.activitySortService.deleteActivity(activityAppId, activityId, activityType));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.getByCondition is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> sort(Long activityAppId, Long activityId, Integer activityType, int location) {
        try {
            return DubboResult.successResult((Object)this.activitySortService.sort(activityAppId, activityId, activityType, location));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.sort is error");
            return this.exceptionFailure(e);
        }
    }
}

