/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.MediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqCreateMediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetMediaAppConfigByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateMediaAppConfigDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMediaAppConfigDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.AccountDAO;
import cn.com.duiba.tuia.media.dao.MediaAppConfigDao;
import cn.com.duiba.tuia.media.dao.MediaAppDao;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.service.MediaAppConfigService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MediaAppConfigServiceImpl
implements MediaAppConfigService {
    protected Logger logger = LoggerFactory.getLogger(MediaAppConfigServiceImpl.class);
    @Autowired
    private MediaAppConfigDao mediaAppCondfigDao;
    @Autowired
    private MediaAppDao mediaAppDao;
    @Autowired
    private AccountDAO accountDao;

    @Override
    public Boolean createMediaAppConfig(ReqCreateMediaAppConfigDto param) throws TuiaMediaException {
        MediaAppConfigDto mediaAppConfigDto = new MediaAppConfigDto();
        mediaAppConfigDto.setAppId(param.getAppId());
        mediaAppConfigDto.setChargeType(param.getChargeType());
        mediaAppConfigDto.setPrice(param.getPrice());
        mediaAppConfigDto.setMediaSplitRatio(param.getMediaSplitRatio());
        mediaAppConfigDto.setPlatformSplitRatio(param.getPlatformSplitRatio());
        mediaAppConfigDto.setIsDeducted(param.getIsDeducted());
        mediaAppConfigDto.setDeductedPercent(param.getDeductedPercent());
        this.mediaAppCondfigDao.insert(mediaAppConfigDto);
        return true;
    }

    @Override
    public PageResultDto<RspMediaAppConfigDto> getMediaAppCondfigList(ReqGetMediaAppConfigByPageDto mediaAppConfigQuery) throws TuiaMediaException {
        mediaAppConfigQuery.setPageSize(Integer.valueOf(50));
        mediaAppConfigQuery.setRowStart((mediaAppConfigQuery.getCurrentPage() - 1) * mediaAppConfigQuery.getPageSize());
        mediaAppConfigQuery.setSort("gmt_create");
        mediaAppConfigQuery.setOrder("desc");
        ArrayList<RspMediaAppConfigDto> rspMediaAppConfigList = null;
        int totalNum = this.mediaAppCondfigDao.selectAmountByPageQuery(mediaAppConfigQuery);
        if (totalNum > 0 && totalNum >= mediaAppConfigQuery.getRowStart()) {
            List<MediaAppDto> mediaAppList = this.mediaAppCondfigDao.selectMediaAppConfigList(mediaAppConfigQuery);
            if (CollectionUtils.isNotEmpty(mediaAppList)) {
                rspMediaAppConfigList = new ArrayList<RspMediaAppConfigDto>(mediaAppList.size());
                ArrayList<Long> mediaIds = new ArrayList<Long>(mediaAppList.size());
                for (MediaAppDto dto : mediaAppList) {
                    mediaIds.add(dto.getMediaId());
                }
                Map<Long, String> accountMap = this.getAccountMapByIds(mediaIds);
                for (MediaAppDto dto : mediaAppList) {
                    RspMediaAppConfigDto rspMediaAppConfig = new RspMediaAppConfigDto();
                    rspMediaAppConfig.setAppId(dto.getAppId());
                    rspMediaAppConfig.setAppName(dto.getAppName());
                    rspMediaAppConfig.setEmail(accountMap != null ? accountMap.get(dto.getMediaId()) : "");
                    rspMediaAppConfig.setCheckStatus(dto.getCheckStatus());
                    rspMediaAppConfig.setPlatform(dto.getPlatform());
                    rspMediaAppConfig.setCreateDate(new DateTime((Object)dto.getGmtCreate()).toString("yyyy-MM-dd"));
                    rspMediaAppConfigList.add(rspMediaAppConfig);
                }
            } else {
                rspMediaAppConfigList = Collections.EMPTY_LIST;
            }
        }
        return new PageResultDto(totalNum, rspMediaAppConfigList, mediaAppConfigQuery.getPageSize().intValue());
    }

    @Override
    public MediaAppConfigDto getMediaAppConfigMsg(Long appId) throws TuiaMediaException {
        MediaAppDto mediaAppDto = this.mediaAppDao.selectMediaAppById(appId);
        if (mediaAppDto == null) {
            this.logger.error("the mediaAppDto is not exist, the appId = [{}]", (Object)appId);
            throw new TuiaMediaException(ErrorCode.E0401004);
        }
        MediaAppConfigDto mediaAppConfigDto = this.mediaAppCondfigDao.selectMediaAppConfigById(appId);
        if (mediaAppConfigDto == null) {
            mediaAppConfigDto = new MediaAppConfigDto();
            mediaAppConfigDto.setPlatformSplitRatio(MediaAppConfigDto.PLATFORM_SPLIT_RATIO_NUM);
            mediaAppConfigDto.setMediaSplitRatio(MediaAppConfigDto.MEDIA_SPLIT_RATIO_NUM);
            mediaAppConfigDto.setIsDeducted(MediaAppConfigDto.IS_DEDUCTED);
            mediaAppConfigDto.setDeductedPercent(MediaAppConfigDto.DEDUCTEDPERCENT_NUM);
        }
        mediaAppConfigDto.setAppId(mediaAppDto.getAppId());
        mediaAppConfigDto.setAppName(mediaAppDto.getAppName());
        return mediaAppConfigDto;
    }

    @Override
    public Boolean updateMediaAppConfig(ReqUpdateMediaAppConfigDto param) throws TuiaMediaException {
        MediaAppConfigDto mediaAppConfigDto = this.mediaAppCondfigDao.selectMediaAppConfigById(param.getAppId());
        if (mediaAppConfigDto == null) {
            Integer isDeducted = param.getIsDeducted() != false ? MediaAppConfigDto.IS_DEDUCTED : MediaAppConfigDto.NO_DEDUCTED;
            mediaAppConfigDto = new MediaAppConfigDto();
            mediaAppConfigDto.setAppId(param.getAppId());
            mediaAppConfigDto.setChargeType(param.getChargeType());
            mediaAppConfigDto.setDeductedPercent(param.getDeductedPercent());
            mediaAppConfigDto.setIsDeducted(isDeducted);
            mediaAppConfigDto.setMediaSplitRatio(param.getMediaSplitRatio());
            mediaAppConfigDto.setPlatformSplitRatio(param.getPlatformSplitRatio());
            if (param.getChargeType() != MediaAppConfigDto.CHARGE_TYPE_DIVIDED_INTO) {
                mediaAppConfigDto.setPrice(param.getPrice());
            }
            mediaAppConfigDto.setPrice(param.getPrice());
            this.mediaAppCondfigDao.insert(mediaAppConfigDto);
            return true;
        }
        if (param.getChargeType() == MediaAppConfigDto.CHARGE_TYPE_DIVIDED_INTO) {
            param.setPrice(mediaAppConfigDto.getPrice());
        } else {
            param.setMediaSplitRatio(mediaAppConfigDto.getMediaSplitRatio());
            param.setPlatformSplitRatio(mediaAppConfigDto.getPlatformSplitRatio());
        }
        this.mediaAppCondfigDao.update(param);
        return true;
    }

    private Map<Long, String> getAccountMapByIds(List<Long> mediaIds) throws TuiaMediaException {
        if (CollectionUtils.isEmpty(mediaIds)) {
            return null;
        }
        int size = mediaIds.size();
        ArrayList<IdAndName> list = new ArrayList<IdAndName>(size);
        HashMap<Long, String> accountMap = new HashMap<Long, String>(size);
        int j = 0;
        for (int i = 1; i <= size; ++i) {
            if (i % 100 != 0 && i != size) continue;
            list.addAll(this.accountDao.selectMediaIdAndEmails(mediaIds.subList(j, i)));
            j = i;
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (IdAndName accountVO : list) {
                accountMap.put(accountVO.getId(), accountVO.getName());
            }
        }
        return accountMap;
    }
}

