/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.common.tool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DataTool {
    public static Long calculateAveragePrice(Long divisor, Long dividend) {
        Long result = null;
        if (dividend != null && dividend != 0L && divisor != null) {
            BigDecimal bigDivisor = new BigDecimal(divisor);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return bigDivisor.divide(bigDividend, 4).longValue();
        }
        return result;
    }

    public static Long calculateEcpm(Long divisor, Long dividend) {
        Long result = null;
        if (dividend != null && dividend != 0L && divisor != null) {
            BigDecimal bigDivisor = new BigDecimal(divisor);
            BigDecimal bigDividend = new BigDecimal(dividend * 1000L);
            return bigDivisor.divide(bigDividend, 2, 4).longValue();
        }
        return result;
    }

    public static Long calculateClickRade(Long divisor, Long dividend) {
        Long result = null;
        if (dividend != null && dividend != 0L && divisor != null) {
            BigDecimal bigDivisor = new BigDecimal(divisor);
            BigDecimal bigDividend = new BigDecimal(dividend);
            return new Double(bigDivisor.divide(bigDividend, 2, 4).doubleValue() * 100.0).longValue();
        }
        return result;
    }

    public static boolean isSame(Integer integer1, Integer integer2) {
        return integer1 == null && integer2 == null || integer1 != null && integer2 != null && integer1.intValue() == integer2.intValue();
    }

    public static boolean isSame(Long long1, Long long2) {
        return long1 == null && long2 == null || long1 != null && long2 != null && long1 - long2 == 0L;
    }

    public static List<Long> getLongListByStr(String arrayStr) {
        if (StringUtils.isBlank((String)arrayStr)) {
            return Collections.emptyList();
        }
        String[] array = arrayStr.split(",");
        ArrayList<Long> list = new ArrayList<Long>();
        for (String s : array) {
            list.add(Long.valueOf(s));
        }
        return list;
    }

    public static String getStringByList(List<String> list) {
        if (!CollectionUtils.isEmpty(list)) {
            StringBuilder builder = new StringBuilder();
            for (String str : list) {
                builder.append(str);
                builder.append(",");
            }
            return builder.substring(0, builder.length() - 1);
        }
        return "";
    }

    public static List<String> getStringListByStr(String arrayStr) {
        if (!StringUtils.isBlank((String)arrayStr)) {
            String[] array;
            ArrayList<String> list = new ArrayList<String>();
            for (String s : array = arrayStr.split(",")) {
                list.add(s);
            }
            return list;
        }
        return Collections.emptyList();
    }
}

