/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.aop;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.dao.OperateLogDAO;
import cn.com.duiba.tuia.media.domain.OperateLogDto;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.utils.RequestLocal;
import cn.com.duiba.tuia.media.web.aop.LogWrite;
import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
public class OperationLogAOP<T> {
    private static final int MAX_PARAM_LENGTH = 200;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OperateLogDAO operateLogDAO;
    private ExecutorService executorService = Executors.newFixedThreadPool(5);

    @Around(value="@annotation(logWrite)", argNames="logWrite")
    public Result<T> interceptorApplogic(ProceedingJoinPoint joinPoint, LogWrite logWrite) throws Throwable {
        Result result = (Result)joinPoint.proceed();
        boolean isSuccess = false;
        if (StringUtils.equals((String)result.getCode(), (String)ErrorCode.E0000000.getErrorCode())) {
            isSuccess = true;
        }
        this.addOPeratorLog(joinPoint, logWrite, isSuccess);
        return result;
    }

    private void addOPeratorLog(ProceedingJoinPoint joinPoint, LogWrite logWrite, boolean isSuccess) {
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        String ip = null;
        if (ra != null) {
            ServletRequestAttributes sra = (ServletRequestAttributes)ra;
            HttpServletRequest request = sra.getRequest();
            ip = request.getRemoteHost();
        }
        this.doAddOperateLog(joinPoint, logWrite, isSuccess, ip, RequestLocal.get().getCid());
    }

    private void doAddOperateLog(final ProceedingJoinPoint joinPoint, final LogWrite logWrite, final boolean isSuccess, final String ip, final Long userId) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    OperateLogDto record = new OperateLogDto();
                    record.setContent(OperationLogAOP.this.getContent(joinPoint.getArgs(), logWrite.ignoreParams()));
                    record.setUserIp(ip);
                    record.setUserId(userId);
                    record.setModelName(logWrite.modelName());
                    record.setIsSuccess(Integer.valueOf(isSuccess ? 1 : 0));
                    record.setOption(logWrite.option());
                    OperationLogAOP.this.operateLogDAO.insert(record);
                }
                catch (Exception e) {
                    OperationLogAOP.this.logger.info(" add operator log error", (Throwable)e);
                }
            }
        });
    }

    private String getContent(Object[] paramsArray, String[] ignoreParams) {
        StringBuilder content = new StringBuilder();
        if (paramsArray != null && paramsArray.length > 0) {
            for (int i = 0; i < paramsArray.length; ++i) {
                if (paramsArray[i] instanceof BindingResult || paramsArray[i] instanceof HttpServletResponse) continue;
                this.doBuildContent(JSONObject.toJSON((Object)paramsArray[i]), ignoreParams, content);
            }
        }
        return content.toString();
    }

    private void doBuildContent(Object paramObj, String[] ignoreParams, StringBuilder content) {
        String[] strList;
        if (paramObj != null && (strList = paramObj.toString().split(",")) != null) {
            for (String str : strList) {
                if (str.length() > 200 || this.ignore(str, ignoreParams)) continue;
                content.append(str);
            }
        }
    }

    private final boolean ignore(String param, String[] ignoreParams) {
        if (ignoreParams == null || ignoreParams.length == 0) {
            return false;
        }
        for (String ignoreParam : ignoreParams) {
            if (!param.contains(ignoreParam)) continue;
            return true;
        }
        return false;
    }
}

