/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.media.bo.AccountBackendBO;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.BlowfishUtils;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.model.req.ReqEmailToken;
import cn.com.duiba.tuia.media.model.req.ReqLogin;
import cn.com.duiba.tuia.media.model.req.ReqRegister;
import cn.com.duiba.tuia.media.model.req.ReqResetPassword;
import cn.com.duiba.tuia.media.model.req.ReqSendEmail;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBank;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBase;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAuditData;
import cn.com.duiba.tuia.media.model.req.ReqVerifyCode;
import cn.com.duiba.tuia.media.model.rsp.AccountInfoRsp;
import cn.com.duiba.tuia.media.model.rsp.RegisterRsp;
import cn.com.duiba.tuia.media.model.rsp.TokenRsp;
import cn.com.duiba.tuia.media.service.AccountService;
import cn.com.duiba.tuia.media.utils.CookieUtil;
import cn.com.duiba.tuia.media.utils.RequestLocal;
import cn.com.duiba.tuia.media.web.aop.LogWrite;
import cn.com.duiba.tuia.media.web.controller.BaseController;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/account"})
@Api(value="\u8d26\u6237\u76f8\u5173api")
public class AccountController
extends BaseController {
    @Value(value="${media.consumer.encrypt.key}")
    private String consumerEncryptKey;
    @Autowired
    private AccountService accountService;
    @Autowired
    private AccountBackendBO accountBackendBO;

    @ApiOperation(value="\u5a92\u4f53\u8d26\u53f7\u662f\u5426\u88ab\u5360\u7528", httpMethod="GET", notes="\u5a92\u4f53\u8d26\u53f7\u662f\u5426\u88ab\u5360\u7528\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/isExists"}, method={RequestMethod.GET})
    public Result<Boolean> isEmailExists(@RequestParam String value) {
        try {
            if (this.accountService.isEmailExists(value)) {
                this.logger.error("email is exist, email =[{}]", (Object)value);
                throw new TuiaMediaException(ErrorCode.E0102011);
            }
            return this.successResult(true);
        }
        catch (Exception e) {
            this.logger.error("AccountController.isEmialExists error!,the param=[{}]", (Object)value);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u624b\u673a\u53f7\u662f\u5426\u88ab\u5360\u7528", httpMethod="GET", notes="\u624b\u673a\u53f7\u662f\u5426\u88ab\u5360\u7528\u63a5\u53e3")
    @ApiImplicitParam(name="value", value="\u624b\u673a\u53f7", required=true, dataType="String", paramType="query")
    @ResponseBody
    @RequestMapping(value={"/isExistPhone"}, method={RequestMethod.GET})
    public Result<Boolean> isExistPhone(@RequestParam String value) {
        try {
            if (this.accountService.isPhoneExists(value)) {
                this.logger.error("linkPhone is exist, phone =[{}]", (Object)value);
                throw new TuiaMediaException(ErrorCode.E0102021);
            }
            return this.successResult(true);
        }
        catch (Exception e) {
            this.logger.error("AccountController.isEmialExists error!,the param=[{}]", (Object)value);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u7528\u6237\u6a21\u5757", option="\u6ce8\u518c", ignoreParams={"passwd"})
    @ApiOperation(value="\u5a92\u4f53\u8d26\u53f7\u6ce8\u518c", httpMethod="POST", notes="\u5a92\u4f53\u8d26\u53f7\u6ce8\u518c\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/register"}, method={RequestMethod.POST})
    public Result<RegisterRsp> register(@Valid @RequestBody ReqRegister req, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.accountBackendBO.register(req));
        }
        catch (Exception e) {
            this.logger.error("AccountController.register error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u6ce8\u518c\u90ae\u4ef6\u9a8c\u8bc1", httpMethod="GET", notes="\u6ce8\u518c\u90ae\u4ef6\u9a8c\u8bc1\u63a5\u53e3")
    @RequestMapping(value={"/verifyEmail"}, method={RequestMethod.GET})
    public String verifyEmail(@Valid @ModelAttribute ReqEmailToken req, BindingResult result) {
        try {
            this.checkParam(result);
            this.accountService.verifyEmail(req.getToken());
            return "redirect:/#/verified?email=" + req.getEmail();
        }
        catch (Exception e) {
            this.logger.error("verifyEmail error!,the param=[{}]", (Object)req);
            return "redirect:/#/unverified?email=" + req.getEmail();
        }
    }

    @ApiOperation(value="\u91cd\u65b0\u53d1\u9001\u9a8c\u8bc1\u90ae\u4ef6", httpMethod="POST", notes="\u91cd\u65b0\u53d1\u9001\u9a8c\u8bc1\u90ae\u4ef6\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/repeatVerifyEmail"}, method={RequestMethod.POST})
    public Result<Boolean> repeatVerifyEmail(@Valid @RequestBody ReqSendEmail req, BindingResult result) {
        try {
            this.checkParam(result);
            this.accountService.repeatVerifyEmail(req.getEmail());
            return this.successResult(true);
        }
        catch (Exception e) {
            this.logger.error("AccountController.repeatVerifyEmail error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u7528\u6237\u6a21\u5757", option="\u767b\u5f55", ignoreParams={"password"})
    @ApiOperation(value="\u5a92\u4f53\u8d26\u53f7\u767b\u5f55", httpMethod="POST", notes="\u5a92\u4f53\u8d26\u53f7\u767b\u5f55\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public Result<Boolean> login(@Valid @RequestBody ReqLogin reqLogin, BindingResult result) {
        try {
            this.checkParam(result);
            this.buildLoginCookie(this.accountBackendBO.login(reqLogin.getEmail(), reqLogin.getPassword()));
            return this.successResult(true);
        }
        catch (Exception e) {
            this.logger.error("AccountController.login error!,the param=[{}]", (Object)reqLogin);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u7528\u6237\u6a21\u5757", option="\u83b7\u53d6\u91cd\u65b0\u63d0\u4ea4\u5a92\u4f53\u8d26\u6237\u5ba1\u6838\u4fe1\u606f")
    @ApiOperation(value="\u83b7\u53d6\u91cd\u65b0\u63d0\u4ea4\u7684\u5a92\u4f53\u8d26\u6237\u5ba1\u6838\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u91cd\u65b0\u63d0\u4ea4\u7684\u5a92\u4f53\u8d26\u6237\u5ba1\u6838\u4fe1\u606f\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/getUncheckAccount"}, method={RequestMethod.GET})
    public Result<AccountInfoRsp> getUncheckAccountInfo(@Valid @ModelAttribute ReqSendEmail req, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.accountBackendBO.getUncheckAccountInfo(req.getEmail()));
        }
        catch (Exception e) {
            this.logger.error("AccountController.getUncheckAccountInfo error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u7528\u6237\u6a21\u5757", option="\u91cd\u65b0\u63d0\u4ea4\u5a92\u4f53\u8d26\u6237\u5ba1\u6838\u4fe1\u606f")
    @ApiOperation(value="\u91cd\u65b0\u63d0\u4ea4\u5a92\u4f53\u8d26\u6237\u5ba1\u6838\u4fe1\u606f", httpMethod="POST", notes="\u91cd\u65b0\u63d0\u4ea4\u5a92\u4f53\u8d26\u6237\u5ba1\u6838\u4fe1\u606f\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/updateAuditData"}, method={RequestMethod.POST})
    public Result<Boolean> updateAuditData(@Valid @RequestBody ReqUpdateAuditData accountInfo, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.accountBackendBO.updateAuditData(accountInfo));
        }
        catch (Exception e) {
            this.logger.error("AccountController.modifyAuditData error!,the param=[{}]", (Object)accountInfo);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u53d1\u9001\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\u90ae\u4ef6", httpMethod="POST", notes="\u53d1\u9001\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\u90ae\u4ef6\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/sendResetPdEmail"}, method={RequestMethod.POST})
    public Result<Boolean> sendResetPdEmail(@Valid @RequestBody ReqSendEmail req, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.accountService.sendResetPasswdEmail(req.getEmail()));
        }
        catch (Exception e) {
            this.logger.error("AccountController.sendResetPdEmail error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u53d1\u9001\u66f4\u6362\u90ae\u7bb1\u9a8c\u8bc1\u7801\u90ae\u4ef6", httpMethod="POST", notes="\u53d1\u9001\u66f4\u6362\u90ae\u7bb1\u9a8c\u8bc1\u7801\u90ae\u4ef6\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/sendReplaceEmail"}, method={RequestMethod.POST})
    public Result<Boolean> sendReplaceEmail(@Valid @RequestBody ReqSendEmail req, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.accountService.sendReplaceEmail(req.getEmail(), RequestLocal.get().getCid()));
        }
        catch (Exception e) {
            this.logger.error("AccountController.sendReplaceEmail error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u7528\u6237\u6a21\u5757", option="\u66f4\u6362\u90ae\u7bb1")
    @ApiOperation(value="\u66f4\u6362\u90ae\u7bb1", httpMethod="POST", notes="\u66f4\u6362\u90ae\u7bb1\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/replaceEmail"}, method={RequestMethod.POST})
    public Result<Boolean> replaceEmail(@RequestBody ReqEmailToken req, BindingResult result) {
        try {
            return this.successResult(this.accountService.replaceEmail(req.getToken(), RequestLocal.get().getCid()));
        }
        catch (Exception e) {
            this.logger.error("AccountController.replaceEmail error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\u6821\u9a8c", httpMethod="POST", notes="\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\u6821\u9a8c\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/verifyResetPdCode"}, method={RequestMethod.POST})
    public Result<TokenRsp> verifyResetPdCode(@Valid @RequestBody ReqVerifyCode req, BindingResult result) {
        try {
            this.checkParam(result);
            return this.successResult(this.accountService.resetPasswdRedirect(req.getEmail(), req.getVerificationCode()));
        }
        catch (Exception e) {
            this.logger.error("AccountController.verifyResetPdCode error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u7528\u6237\u6a21\u5757", option="\u91cd\u7f6e\u5bc6\u7801", ignoreParams={"newPassword"})
    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801", httpMethod="POST", notes="\u91cd\u7f6e\u5bc6\u7801\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/resetPassword"}, method={RequestMethod.POST})
    public Result<Boolean> resetPassword(@Valid @RequestBody ReqResetPassword req, BindingResult result) {
        try {
            this.checkParam(result);
            boolean flag = this.accountService.resetPassword(req.getEmail(), req.getNewPassword(), req.getToken());
            CookieUtil.deleteCookie((String)"dataxyz345");
            return this.successResult(flag);
        }
        catch (Exception e) {
            this.logger.error("AccountController.resetPasswd error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u8be6\u60c5", httpMethod="GET", notes="\u67e5\u8be2\u7528\u6237\u8be6\u60c5\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/getAccountInfo"}, method={RequestMethod.GET})
    public Result<AccountInfoRsp> getAccountInfo() {
        try {
            Long mediaId = RequestLocal.get().getCid();
            return this.successResult(this.accountBackendBO.getAccountInfo(mediaId));
        }
        catch (Exception e) {
            this.logger.error("AccountController.getAccountInfo error!");
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u7528\u6237\u6a21\u5757", option="\u4fee\u6539\u7528\u6237\u57fa\u672c\u4fe1\u606f")
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u57fa\u672c\u4fe1\u606f", httpMethod="POST", notes="\u4fee\u6539\u7528\u6237\u57fa\u672c\u4fe1\u606f\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/updateAccountBase"}, method={RequestMethod.POST})
    public Result<Boolean> updateAccountBase(@RequestBody ReqUpdateAccountBase req) {
        try {
            req.setMediaId(RequestLocal.get().getCid());
            return this.successResult(this.accountService.updateAccountBase(req));
        }
        catch (Exception e) {
            this.logger.error("AccountController.updateAccountBase error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u7528\u6237\u6a21\u5757", option="\u4fee\u6539\u7528\u6237\u8d22\u52a1\u4fe1\u606f")
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u8d22\u52a1\u4fe1\u606f", httpMethod="POST", notes="\u4fee\u6539\u7528\u6237\u57fa\u672c\u4fe1\u606f\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/updateAccountBank"}, method={RequestMethod.POST})
    public Result<Boolean> updateAccountBank(@RequestBody ReqUpdateAccountBank req) {
        try {
            req.setMediaId(RequestLocal.get().getCid());
            return this.successResult(this.accountService.updateAccountBank(req));
        }
        catch (Exception e) {
            this.logger.error("AccountController.updateAccountBank error!,the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u5a92\u4f53\u8d26\u6237\u9000\u51fa", httpMethod="POST", notes="\u5a92\u4f53\u8d26\u6237\u9000\u51fa\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/logout"}, method={RequestMethod.POST})
    public Result<Boolean> logout() {
        try {
            CookieUtil.deleteCookie((String)"dataxyz345");
            return this.successResult(true);
        }
        catch (Exception e) {
            this.logger.error("AccountController.logout error!");
            return this.failResult(e);
        }
    }

    private void buildLoginCookie(Long mediaId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("loginTime", (Object)new Date().getTime());
        jsonObject.put("accountId", (Object)mediaId);
        String envalue = BlowfishUtils.encryptBlowfish((String)jsonObject.toJSONString(), (String)this.consumerEncryptKey);
        CookieUtil.setCrossCookie((String)"dataxyz345", (String)envalue);
    }
}

