/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetAccountByPageDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAccountBaseDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.constants.TuiaDomainConstant;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.tool.IDGeneratorTool;
import cn.com.duiba.tuia.media.common.utils.BlowfishUtils;
import cn.com.duiba.tuia.media.common.utils.MessageDigestUtils;
import cn.com.duiba.tuia.media.dao.AccountBankDAO;
import cn.com.duiba.tuia.media.dao.AccountCheckRecordDAO;
import cn.com.duiba.tuia.media.dao.AccountDAO;
import cn.com.duiba.tuia.media.model.Email;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBank;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBase;
import cn.com.duiba.tuia.media.model.rsp.TokenRsp;
import cn.com.duiba.tuia.media.service.AccountService;
import cn.com.duiba.tuia.media.service.EmailService;
import cn.com.duiba.tuia.media.service.impl.BaseCacheService;
import cn.com.duiba.tuia.media.service.impl.MediaCacheService;
import cn.com.duiba.tuia.media.utils.CacheKeyUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AccountServiceImpl
extends BaseCacheService
implements AccountService {
    private static final int EMAIL_CODE_LENGTH = 6;
    private static final int THIRTY_MINUTES = 1800;
    private static final int ONE_HOUR = 3600;
    private static final int FORTYEIGHT_HOURS = 172800;
    @Value(value="${media.login.encrypt.key}")
    private String loginEncryptKey;
    @Value(value="${media.email.verify.key}")
    private String emailVerifyKey;
    @Autowired
    private EmailService emailService;
    @Autowired
    private AccountDAO accountDAO;
    @Autowired
    private AccountBankDAO accountBankDAO;
    @Autowired
    private AccountCheckRecordDAO accountCheckRecordDao;
    @Autowired
    private MediaCacheService mediaCacheService;

    @Override
    public boolean isEmailExists(String email) throws TuiaMediaException {
        return this.accountDAO.selectByEmail(email) != null;
    }

    @Override
    public boolean sendResetPasswdEmail(String email) throws TuiaMediaException {
        AccountDto accountDto = this.accountDAO.selectByEmail(email);
        this.accountDtoIsNull(accountDto);
        this.doSendResetPasswdEmail(accountDto.getLinkman(), email);
        return true;
    }

    @Override
    public boolean sendReplaceEmail(String email, Long userId) throws TuiaMediaException {
        AccountDto user = this.selectByIdNotNull(userId);
        AccountDto accountDto = this.accountDAO.selectByEmail(email);
        if (accountDto != null) {
            if (accountDto.getMediaId().longValue() == userId.longValue()) {
                throw new TuiaMediaException(ErrorCode.E0104017);
            }
            throw new TuiaMediaException(ErrorCode.E0102016);
        }
        this.doSendReplaceEmail(user.getLinkman(), email, userId);
        return true;
    }

    @Override
    public boolean replaceEmail(String token, Long userId) throws TuiaMediaException {
        String cacheEmail = this.redisClient.get(CacheKeyUtils.getReplaceEmailKey(userId, token));
        if (StringUtils.isEmpty((String)cacheEmail)) {
            throw new TuiaMediaException(ErrorCode.E0102003);
        }
        if (this.accountDAO.updateEmail(userId, cacheEmail) != 1) {
            throw new TuiaMediaException(ErrorCode.E0102018);
        }
        this.redisClient.del(CacheKeyUtils.getReplaceEmailKey(userId, token));
        return true;
    }

    @Override
    public AccountDto selectByIdNotNull(Long mediaId) throws TuiaMediaException {
        AccountDto user = this.accountDAO.selectById(mediaId);
        if (user == null) {
            throw new TuiaMediaException(ErrorCode.E0102001);
        }
        return user;
    }

    @Override
    public TokenRsp resetPasswdRedirect(String email, String verificationCode) throws TuiaMediaException {
        String cacheCode = this.redisClient.get(CacheKeyUtils.getResetPwEmailKey(email));
        if (!StringUtils.equals((String)verificationCode, (String)cacheCode)) {
            this.logger.error("the verificationCode invalid, the email=[{}]", (Object)email);
            throw new TuiaMediaException(ErrorCode.E0102003);
        }
        String key = new Date().getTime() + "-" + email;
        String token = BlowfishUtils.encryptBlowfish((String)key, (String)this.emailVerifyKey);
        this.redisClient.setex(token, 1800, email);
        TokenRsp tokenRsp = new TokenRsp();
        tokenRsp.setEmail(email);
        tokenRsp.setToken(token);
        return tokenRsp;
    }

    @Override
    public boolean resetPassword(String email, String newPasswd, String token) throws TuiaMediaException {
        String cacheToken = this.redisClient.get(token);
        if (null == cacheToken) {
            this.logger.error("the token invalid, the email=[{}]", (Object)email);
            throw new TuiaMediaException(ErrorCode.E0102009);
        }
        String newPd = BlowfishUtils.encryptBlowfish((String)MessageDigestUtils.SHA((String)newPasswd), (String)this.loginEncryptKey);
        AccountDto accountDto = this.accountDAO.selectByEmail(email);
        this.accountDtoIsNull(accountDto);
        if (newPd.equals(accountDto.getPassword())) {
            throw new TuiaMediaException(ErrorCode.E0102013);
        }
        int count = this.accountDAO.updatePasswdByEmail(email, newPd);
        if (count > 0) {
            this.redisClient.del(CacheKeyUtils.getResetPwEmailKey(email));
            this.redisClient.del(token);
            return true;
        }
        return false;
    }

    @Override
    public void verifyEmail(String token) throws TuiaMediaException {
        String value = this.redisClient.get(token);
        if (value == null) {
            this.logger.error("token has invalid, the token=[{}]", (Object)token);
            throw new TuiaMediaException(ErrorCode.E0102003);
        }
        AccountDto accountDto = this.accountDAO.selectByEmail(value);
        this.accountDtoIsNull(accountDto);
        this.accountDAO.updateEmailStatus(accountDto.getMediaId(), 1);
        this.redisClient.del(token);
    }

    private void doSendResetPasswdEmail(final String linkman, final String userEmail) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                String verificationCode = IDGeneratorTool.getRandomString((int)6);
                HashMap<String, Object> model = new HashMap<String, Object>(3);
                model.put("linkman", linkman);
                model.put("email", userEmail);
                model.put("verificationCode", verificationCode);
                Email email = new Email();
                email.setTo(userEmail);
                email.setTemplateLocation("/templates/mail/resetpasswd.vm");
                email.setSubject("\u63a8\u554a\u5a92\u4f53\u8d26\u53f7\u627e\u56de\u5bc6\u7801-\u90ae\u7bb1\u9a8c\u8bc1\u7801");
                email.setModel(model);
                AccountServiceImpl.this.emailService.sendWithTemplate(email);
                AccountServiceImpl.this.redisClient.setex(CacheKeyUtils.getResetPwEmailKey(userEmail), 1800, verificationCode);
            }
        });
    }

    private void doSendReplaceEmail(final String linkman, final String userEmail, final Long userId) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                String verificationCode = IDGeneratorTool.getRandomString((int)6);
                HashMap<String, Object> model = new HashMap<String, Object>(3);
                model.put("linkman", linkman);
                model.put("email", userEmail);
                model.put("verificationCode", verificationCode);
                Email email = new Email();
                email.setTo(userEmail);
                email.setTemplateLocation("/templates/mail/replaceEmail.vm");
                email.setSubject("\u63a8\u554a\u5a92\u4f53\u66f4\u6362\u90ae\u7bb1\u901a\u77e5");
                email.setModel(model);
                AccountServiceImpl.this.emailService.sendWithTemplate(email);
                AccountServiceImpl.this.redisClient.setex(CacheKeyUtils.getReplaceEmailKey(userId, verificationCode), 3600, userEmail);
            }
        });
    }

    @Override
    public void doSendVerifyEmail(final AccountDto accountDto) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                String key = new Date().getTime() + "-" + accountDto.getMediaId();
                String code = BlowfishUtils.encryptBlowfish((String)key, (String)AccountServiceImpl.this.emailVerifyKey);
                String email = accountDto.getEmail();
                String url = TuiaDomainConstant.getTuia_domain_name() + "/account/verifyEmail?email=" + email + "&token=" + code;
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("linkman", accountDto.getLinkman());
                model.put("email", email);
                model.put("url", url);
                Email sendEmail = new Email();
                sendEmail.setTo(accountDto.getEmail());
                sendEmail.setTemplateLocation("/templates/mail/active.vm");
                sendEmail.setSubject("\u63a8\u554a\u5a92\u4f53\u8d26\u53f7\u90ae\u7bb1\u9a8c\u8bc1");
                sendEmail.setModel(model);
                AccountServiceImpl.this.emailService.sendWithTemplate(sendEmail);
                AccountServiceImpl.this.redisClient.setex(code, 172800, accountDto.getEmail());
            }
        });
    }

    @Override
    public void repeatVerifyEmail(String email) throws TuiaMediaException {
        AccountDto accountDto = this.accountDAO.selectByEmail(email);
        this.accountDtoIsNull(accountDto);
        int emailStatus = accountDto.getEmailStatus();
        if (1 == emailStatus) {
            throw new TuiaMediaException(ErrorCode.E0102012);
        }
        this.doSendVerifyEmail(accountDto);
    }

    @Override
    public boolean updateAccountBase(ReqUpdateAccountBase req) throws TuiaMediaException {
        this.accountDAO.updateAccount(req);
        this.mediaCacheService.updateMediaCache(req.getMediaId(), false);
        return true;
    }

    @Override
    public boolean updateAccountBank(ReqUpdateAccountBank req) throws TuiaMediaException {
        this.accountBankDAO.update(req);
        this.mediaCacheService.updateMediaCache(req.getMediaId(), false);
        return true;
    }

    @Override
    public PageResultDto<RspAccountBaseDto> pageQuery(ReqGetAccountByPageDto req) throws TuiaMediaException {
        Integer totalAmount = this.accountDAO.selectMediaDataAmount(req);
        List<AccountDto> accountDtos = null;
        ArrayList<RspAccountBaseDto> mediaRsps = new ArrayList<RspAccountBaseDto>();
        if (totalAmount != 0 && totalAmount >= req.getRowStart()) {
            req.setRowStart(req.getPageSize() * (req.getCurrentPage() - 1));
            accountDtos = this.accountDAO.selectMediaDataByPage(req);
        }
        if (CollectionUtils.isNotEmpty(accountDtos)) {
            for (AccountDto accountDto : accountDtos) {
                RspAccountBaseDto rspAccountBase = new RspAccountBaseDto();
                rspAccountBase.setMediaId(accountDto.getMediaId());
                rspAccountBase.setEmail(accountDto.getEmail());
                rspAccountBase.setEmailStatus(accountDto.getEmailStatus());
                rspAccountBase.setCompanyName(accountDto.getCompanyName());
                rspAccountBase.setBusinessLicenseId(accountDto.getBusinessLicenseId());
                rspAccountBase.setBusinessLicenseUrl(accountDto.getBusinessLicenseUrl());
                rspAccountBase.setLinkman(accountDto.getLinkman());
                rspAccountBase.setLinkmanPhone(accountDto.getLinkPhone());
                rspAccountBase.setCheckStatus(accountDto.getCheckStatus());
                rspAccountBase.setFreezeStatus(accountDto.getFreezeStatus());
                mediaRsps.add(rspAccountBase);
            }
        }
        return new PageResultDto(totalAmount.intValue(), mediaRsps, req.getPageSize().intValue());
    }

    @Override
    public boolean updateCheckStatus(Long mediaId, Integer status) throws TuiaMediaException {
        boolean flag;
        boolean bl = flag = this.accountDAO.updateCheckStatus(mediaId, status) == 1;
        if (flag && 1 == status) {
            this.mediaCacheService.updateMediaCache(mediaId, true);
        }
        return flag;
    }

    @Override
    public boolean updateFreezeStatus(Long mediaId, Integer status) throws TuiaMediaException {
        boolean flag;
        boolean bl = flag = this.accountDAO.updateFreezeStatus(mediaId, status) == 1;
        if (flag) {
            if (0 == status) {
                this.mediaCacheService.updateMediaCache(mediaId, true);
            }
            if (1 == status) {
                this.mediaCacheService.updateMediaCache(mediaId, false);
            }
        }
        return flag;
    }

    @Override
    public boolean insertAccountBase(AccountDto accountDto) throws TuiaMediaException {
        return this.accountDAO.insert(accountDto) == 1;
    }

    @Override
    public AccountDto selectByMediaId(Long mediaId) throws TuiaMediaException {
        return this.accountDAO.selectById(mediaId);
    }

    @Override
    public AccountDto selectByEmail(String email) throws TuiaMediaException {
        return this.accountDAO.selectByEmail(email);
    }

    @Override
    public boolean updateAuditData(AccountDto req) throws TuiaMediaException {
        return this.accountDAO.updateAuditData(req) == 1;
    }

    @Override
    public void accountDtoIsNull(AccountDto dto) throws TuiaMediaException {
        if (dto == null) {
            this.logger.error("the account is not exist");
            throw new TuiaMediaException(ErrorCode.E0102001);
        }
    }

    @Override
    public boolean isPhoneExists(String linkPhone) throws TuiaMediaException {
        return this.accountDAO.selectByPhone(linkPhone) != null;
    }
}

