/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.SlotCacheDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.StrategyDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.constants.SlotPictureSizeEnmu;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ShieldStrategyDAO;
import cn.com.duiba.tuia.media.dao.SlotDAO;
import cn.com.duiba.tuia.media.domain.ShieldStrategyDto;
import cn.com.duiba.tuia.media.service.impl.BaseCacheService;
import cn.com.duiba.tuia.media.utils.CacheKeyUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SlotCacheService
extends BaseCacheService {
    @Autowired
    private SlotDAO slotDAO;
    @Autowired
    private ShieldStrategyDAO shieldStrategyDAO;

    public SlotCacheDto getSlot(long slotId) throws TuiaMediaException {
        String strSlot = this.redisClient.get(CacheKeyUtils.getSlotKey(slotId));
        SlotCacheDto slotCacheDto = null;
        slotCacheDto = StringUtils.isEmpty((String)strSlot) ? this.doGetSlot(slotId) : (SlotCacheDto)JSONObject.parseObject((String)strSlot, SlotCacheDto.class);
        if (slotCacheDto == null) {
            throw new TuiaMediaException(ErrorCode.E0304008);
        }
        return slotCacheDto;
    }

    public void updateSlotCache(final long slotId) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    SlotCacheService.this.doGetSlot(slotId);
                }
                catch (TuiaMediaException e) {
                    SlotCacheService.this.logger.error("updateSlotCache error", (Throwable)e);
                }
            }
        });
    }

    public void updatebatchSlotCache(final List<Long> slotIds) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (CollectionUtils.isNotEmpty((Collection)slotIds)) {
                        for (Long slotId : slotIds) {
                            SlotCacheService.this.doGetSlot(slotId);
                        }
                    }
                }
                catch (TuiaMediaException e) {
                    SlotCacheService.this.logger.error("updateSlotCache error", (Throwable)e);
                }
            }
        });
    }

    private SlotCacheDto doGetSlot(long slotId) throws TuiaMediaException {
        SlotDto slotDto = this.slotDAO.selectById(slotId);
        SlotCacheDto slotCacheDto = null;
        if (slotDto != null) {
            SlotPictureSizeEnmu.PictureSize pictureSize = SlotPictureSizeEnmu.getPictureSizeById((int)slotDto.getPictureSize());
            if (pictureSize == null) {
                this.logger.error(" the slot=[{}] pictureSizeId=[{}] non-existent", (Object)slotId, (Object)slotDto.getPictureSize());
                return null;
            }
            slotCacheDto = new SlotCacheDto(Long.valueOf(slotId), slotDto.getSlotType(), pictureSize.getWidth(), pictureSize.getHeight(), slotDto.getStrategyId());
            this.redisClient.setex(CacheKeyUtils.getSlotKey(slotId), 604800, JSONObject.toJSONString((Object)slotCacheDto));
        }
        return slotCacheDto;
    }

    public StrategyDto getStrategy(long slotId) throws TuiaMediaException {
        Long strategyId = this.getStrategyIdBySlotId(slotId);
        if (strategyId == null) {
            return null;
        }
        StrategyDto strategyDto = null;
        String strategy = this.redisClient.get(CacheKeyUtils.getStrategyKey(strategyId));
        strategyDto = StringUtils.isEmpty((String)strategy) ? this.doGetStrategy(strategyId) : (StrategyDto)JSONObject.parseObject((String)strategy, StrategyDto.class);
        return strategyDto;
    }

    public StrategyDto updateStrategy(long slotId) throws TuiaMediaException {
        Long strategyId = this.getStrategyIdBySlotId(slotId);
        if (strategyId == null) {
            return null;
        }
        return this.doGetStrategy(strategyId);
    }

    private Long getStrategyIdBySlotId(Long slotId) throws TuiaMediaException {
        SlotCacheDto slot = this.getSlot(slotId);
        if (slot == null) {
            throw new TuiaMediaException(ErrorCode.E0304008);
        }
        return slot.getStrategyId();
    }

    private StrategyDto doGetStrategy(long strategyId) throws TuiaMediaException {
        StrategyDto strategyDto = null;
        ShieldStrategyDto shieldStrategyDto = this.shieldStrategyDAO.selectById(strategyId);
        if (shieldStrategyDto != null) {
            strategyDto = new StrategyDto(shieldStrategyDto.getShieldIndustries(), shieldStrategyDto.getShieldUrls());
            this.redisClient.setex(CacheKeyUtils.getStrategyKey(strategyId), 604800, JSONObject.toJSONString((Object)strategyDto));
        }
        return strategyDto;
    }
}

