/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.tool.IDGeneratorTool;
import cn.com.duiba.tuia.media.model.req.ReqSendSMS;
import cn.com.duiba.tuia.media.service.SmsService;
import cn.com.duiba.tuia.media.utils.CacheKeyUtils;
import cn.com.duiba.tuia.media.utils.SmsUtils;
import cn.com.duiba.wolf.redis.RedisClient;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsServiceImpl
implements SmsService {
    private static final int TEN_MINUTES = 600;
    private static final int REGISTER = 1;
    @Autowired
    private RedisClient redisClient;
    private static final int SMS_CODE_LENGTH = 6;

    @Override
    public Boolean send(ReqSendSMS req) throws TuiaMediaException {
        String code = IDGeneratorTool.getRandomInt((int)6);
        this.redisClient.setex(CacheKeyUtils.getSmsKey(req.getLinkPhone(), req.getType()), 600, code);
        if (1 != req.getType()) {
            throw new TuiaMediaException(ErrorCode.E0001009);
        }
        String text = "\u3010\u5151\u5427\u79d1\u6280\u3011\u5c0a\u656c\u7684\u7528\u6237\uff0c\u60a8\u7684\u6ce8\u518c\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e3a\uff1a" + code + "\uff0c10\u5206\u949f\u5185\u6709\u6548";
        SmsUtils.sendCodeSms(req.getLinkPhone(), text);
        return true;
    }

    @Override
    public Boolean verify(int type, String phone, String code) throws TuiaMediaException {
        String cacheCode = this.redisClient.get(CacheKeyUtils.getSmsKey(phone, type));
        if (StringUtils.equals((String)code, (String)cacheCode)) {
            this.redisClient.del(CacheKeyUtils.getSmsKey(phone, type));
            return true;
        }
        throw new TuiaMediaException(ErrorCode.E0001010);
    }
}

