/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.DataStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.SlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.SlotStatisticsDAO;
import cn.com.duiba.tuia.media.service.SlotLineStatisticsService;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SoltLineStatisticsServiceImpl
implements SlotLineStatisticsService {
    @Autowired
    SlotStatisticsDAO slotStatisticDao;

    @Override
    public List<MediaAppStatisticsDto> getMediaAppStatisticsData(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        ReqMediaAppStatisticsDto dto = new ReqMediaAppStatisticsDto();
        dto.setStartTime(param.getStartDate());
        dto.setEndTime(param.getEndDate());
        List<MediaAppStatisticsDto> mediaAppList = this.slotStatisticDao.selectListMediaDataByPage(dto, Collections.EMPTY_LIST);
        if (CollectionUtils.isEmpty(mediaAppList)) {
            return Collections.EMPTY_LIST;
        }
        return mediaAppList;
    }

    @Override
    public List<SlotStatisticsDto> getSlotStatisticsData(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        ReqSlotStatisticsDto dto = new ReqSlotStatisticsDto();
        dto.setStartTime(param.getStartDate());
        dto.setEndTime(param.getEndDate());
        List<SlotStatisticsDto> slotList = this.slotStatisticDao.selectListSlotDataByPage(dto, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        if (CollectionUtils.isEmpty(slotList)) {
            return Collections.EMPTY_LIST;
        }
        return slotList;
    }

    @Override
    public List<DataStatisticsDto> getStatisticsDataByDate(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        List<DataStatisticsDto> dataList = this.slotStatisticDao.selectByDate(param);
        if (CollectionUtils.isEmpty(dataList)) {
            return Collections.EMPTY_LIST;
        }
        return dataList;
    }

    @Override
    public int getMediaAppDataAmount(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        ReqMediaAppStatisticsDto dto = new ReqMediaAppStatisticsDto();
        dto.setStartTime(param.getStartDate());
        dto.setEndTime(param.getEndDate());
        dto.setMediaId(param.getMediaId());
        return this.slotStatisticDao.selectMediaDataAmount(dto, Collections.EMPTY_LIST);
    }

    @Override
    public int getSlotDataAmount(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        ReqSlotStatisticsDto dto = new ReqSlotStatisticsDto();
        dto.setStartTime(param.getStartDate());
        dto.setEndTime(param.getEndDate());
        dto.setMediaId(param.getMediaId());
        return this.slotStatisticDao.selectSlotDataAmout(dto, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }
}

