/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.DateUtil;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ObjectMetadata {
    private Map<String, String> userMetadata = new HashMap<String, String>();
    private Map<String, Object> metadata = new HashMap<String, Object>();
    public static final String AES_256_SERVER_SIDE_ENCRYPTION = "AES256";

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        CodingUtils.assertParameterNotNull(userMetadata, "userMetadata");
        this.userMetadata = userMetadata;
    }

    public void setHeader(String key, Object value) {
        this.metadata.put(key, value);
    }

    public void addUserMetadata(String key, String value) {
        this.userMetadata.put(key, value);
    }

    public Date getLastModified() {
        return (Date)this.metadata.get("Last-Modified");
    }

    public void setLastModified(Date lastModified) {
        this.metadata.put("Last-Modified", lastModified);
    }

    public Date getExpirationTime() {
        return (Date)this.metadata.get("Expires");
    }

    public void setExpirationTime(Date expirationTime) {
        this.metadata.put("Expires", DateUtil.formatRfc822Date(expirationTime));
    }

    public long getContentLength() {
        Long contentLength = (Long)this.metadata.get("Content-Length");
        if (contentLength == null) {
            return 0L;
        }
        return contentLength;
    }

    public void setContentLength(long contentLength) {
        if (contentLength > 0x140000000L) {
            throw new IllegalArgumentException("\u5185\u5bb9\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc75G\u5b57\u8282\u3002");
        }
        this.metadata.put("Content-Length", contentLength);
    }

    public String getContentType() {
        return (String)this.metadata.get("Content-Type");
    }

    public void setContentType(String contentType) {
        this.metadata.put("Content-Type", contentType);
    }

    public String getContentEncoding() {
        return (String)this.metadata.get("Content-Encoding");
    }

    public void setContentEncoding(String encoding) {
        this.metadata.put("Content-Encoding", encoding);
    }

    public String getCacheControl() {
        return (String)this.metadata.get("Cache-Control");
    }

    public void setCacheControl(String cacheControl) {
        this.metadata.put("Cache-Control", cacheControl);
    }

    public String getContentDisposition() {
        return (String)this.metadata.get("Content-Disposition");
    }

    public void setContentDisposition(String disposition) {
        this.metadata.put("Content-Disposition", disposition);
    }

    public String getETag() {
        return (String)this.metadata.get("ETag");
    }

    public String getServerSideEncryption() {
        return (String)this.metadata.get("x-oss-server-side-encryption");
    }

    public void setServerSideEncryption(String serverSideEncryption) {
        this.metadata.put("x-oss-server-side-encryption", serverSideEncryption);
    }

    public Map<String, Object> getRawMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }
}

