/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.spring.datasource;

import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionUtils {
    private static final Logger log = LoggerFactory.getLogger(TransactionUtils.class);

    private TransactionUtils() {
    }

    public static boolean isCurrentThreadInTransaction() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    public static boolean isCurrentDataSourceInTransaction(DataSource dataSource) {
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)dataSource);
        if (conHolder == null) {
            return false;
        }
        try {
            Method m = ConnectionHolder.class.getDeclaredMethod("isTransactionActive", new Class[0]);
            m.setAccessible(true);
            Boolean b = (Boolean)m.invoke((Object)conHolder, new Object[0]);
            return b;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

