/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.auth.RequestSigner;
import com.aliyun.oss.common.auth.ServiceCredentials;
import com.aliyun.oss.common.auth.ServiceSignature;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.internal.SignUtils;

public class OSSRequestSigner
implements RequestSigner {
    private String httpMethod;
    private String resourcePath;
    private ServiceCredentials credentials;

    public OSSRequestSigner(String httpMethod, String resourcePath, ServiceCredentials credentials) {
        assert (credentials != null);
        this.httpMethod = httpMethod;
        this.resourcePath = resourcePath;
        this.credentials = credentials;
    }

    @Override
    public void sign(RequestMessage request) throws ClientException {
        String secretAccessKey = this.credentials.getAccessKeySecret();
        String accessId = this.credentials.getAccessKeyId();
        if (accessId.length() > 0 && secretAccessKey.length() > 0) {
            String canonicalString = SignUtils.buildCanonicalString(this.httpMethod, this.resourcePath, request, null);
            String signature = ServiceSignature.create().computeSignature(secretAccessKey, canonicalString);
            request.addHeader("Authorization", "OSS " + accessId + ":" + signature);
        } else if (accessId.length() > 0) {
            request.addHeader("Authorization", accessId);
        }
    }
}

