/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.impl;

import com.google.code.yanf4j.core.Session;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.KeyIterator;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.command.text.TextCacheDumpCommand;
import net.rubyeye.xmemcached.exception.MemcachedException;
import net.rubyeye.xmemcached.exception.MemcachedServerException;
import net.rubyeye.xmemcached.utils.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyIteratorImpl
implements KeyIterator {
    private final LinkedList<Integer> itemNumbersList;
    private LinkedList<String> currentKeyList;
    private final MemcachedClient memcachedClient;
    private final InetSocketAddress inetSocketAddress;
    private long opTimeout = 1000L;

    public KeyIteratorImpl(LinkedList<Integer> itemNumbersList, MemcachedClient memcachedClient, InetSocketAddress inetSocketAddress) {
        this.itemNumbersList = itemNumbersList;
        this.memcachedClient = memcachedClient;
        this.inetSocketAddress = inetSocketAddress;
    }

    @Override
    public final InetSocketAddress getServerAddress() {
        return this.inetSocketAddress;
    }

    @Override
    public final void setOpTimeout(long opTimeout) {
        this.opTimeout = opTimeout;
    }

    @Override
    public void close() {
        this.itemNumbersList.clear();
        this.currentKeyList.clear();
        this.currentKeyList = null;
    }

    @Override
    public boolean hasNext() {
        return this.itemNumbersList != null && !this.itemNumbersList.isEmpty() || this.currentKeyList != null && !this.currentKeyList.isEmpty();
    }

    @Override
    public String next() throws MemcachedException, TimeoutException, InterruptedException {
        TextCacheDumpCommand textCacheDumpCommand;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.currentKeyList != null && !this.currentKeyList.isEmpty()) {
            return this.currentKeyList.remove();
        }
        int itemNumber = this.itemNumbersList.remove();
        Queue<Session> sessions = this.memcachedClient.getConnector().getSessionByAddress(this.inetSocketAddress);
        if (sessions == null || sessions.size() == 0) {
            throw new MemcachedException("The memcached server is not connected,address=" + this.inetSocketAddress);
        }
        Session session = sessions.peek();
        CountDownLatch latch = new CountDownLatch(1);
        if (this.memcachedClient.getProtocol() == Protocol.Text) {
            textCacheDumpCommand = new TextCacheDumpCommand(latch, itemNumber);
            session.write(textCacheDumpCommand);
            if (!latch.await(this.opTimeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("stats cachedump timeout");
            }
            if (textCacheDumpCommand.getException() != null) {
                if (textCacheDumpCommand.getException() instanceof MemcachedException) {
                    throw (MemcachedException)textCacheDumpCommand.getException();
                }
                throw new MemcachedServerException(textCacheDumpCommand.getException());
            }
        } else {
            throw new MemcachedException(this.memcachedClient.getProtocol().name() + " protocol doesn't support iterating all keys in memcached");
        }
        this.currentKeyList = (LinkedList)textCacheDumpCommand.getResult();
        return this.next();
    }
}

