/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.api.dto.AccountChangeDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqAccountChange;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.AccountChangeDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="accountChangeDAO")
public class AccountChangeDAOImpl
extends BaseDAO
implements AccountChangeDAO {
    @Override
    public int selectAccountChangeCount(ReqAccountChange req) throws TuiaMediaException {
        try {
            return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("selectAccountChangeCount"), (Object)req);
        }
        catch (Exception e) {
            this.logger.error("AccountChangeDAOImpl.selectAccountChangeCount data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<AccountChangeDto> selectAccountChangeList(ReqAccountChange req) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectAccountChangeList"), (Object)req);
        }
        catch (Exception e) {
            this.logger.error("AccountChangeDAOImpl.selectAccountChangeList data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public void insertAccountChange(AccountChangeDto accountChangeDto) throws TuiaMediaException {
        try {
            this.getSqlSession().insert(this.getStamentNameSpace("insertAccountChange"), (Object)accountChangeDto);
        }
        catch (Exception e) {
            this.logger.error("AccountChangeDAOImpl.insertAccountChange data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public Long selectAccountBalance(Long mediaId) throws TuiaMediaException {
        try {
            return (Long)this.getSqlSession().selectOne(this.getStamentNameSpace("selectAccountBalance"), (Object)mediaId);
        }
        catch (Exception e) {
            this.logger.error("AccountChangeDAOImpl.selectAccountBalance data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<AccountChangeDto> selectAccountChangeListByIds(List<Long> ids) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectAccountChangeListByIds"), ids);
        }
        catch (Exception e) {
            this.logger.error("AccountChangeDAOImpl.selectAccountChangeListByIds data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public AccountChangeDto selectAccountChangeById(Long id) throws TuiaMediaException {
        try {
            return (AccountChangeDto)this.getSqlSession().selectOne(this.getStamentNameSpace("selectAccountChangeById"), (Object)id);
        }
        catch (Exception e) {
            this.logger.error("AccountChangeDAOImpl.selectAccountChangeById data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public AccountChangeDto selectAccountChangeByMediaId(Long mediaId) throws TuiaMediaException {
        try {
            return (AccountChangeDto)this.getSqlSession().selectOne(this.getStamentNameSpace("selectAccountChangeByMediaId"), (Object)mediaId);
        }
        catch (Exception e) {
            this.logger.error("AccountChangeDAOImpl.selectAccountChangeByMediaId data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

