/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityDAOImpl
extends BaseDAO
implements ActivityDAO {
    @Override
    public int insertBatch(List<ActivityDto> activityDtoList) throws TuiaMediaException {
        try {
            return this.getSqlSession().insert(this.getStamentNameSpace("insertBatch"), activityDtoList);
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.insert data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int update(ActivityDto activityDto) throws TuiaMediaException {
        try {
            return this.getSqlSession().update(this.getStamentNameSpace("update"), (Object)activityDto);
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.update happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivityDto> selectByActivityIds(List<Long> activityIds) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectByActivityIds"), activityIds);
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.selectByActivityIds happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<Long> selectByTypeAndName(String name, Integer type) throws TuiaMediaException {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("name", name);
            map.put("type", type);
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectByTypeAndName"), map);
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.selectByTypeAndName happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public ActivityDto selectByActivityIdAndType(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>(2);
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return (ActivityDto)((Object)this.getSqlSession().selectOne(this.getStamentNameSpace("selectByActivityIdAndType"), map));
        }
        catch (Exception e) {
            this.logger.error("ActivityDAO.selectByActivityIdAndType happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

