/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivitySortDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class ActivitySortDAOImpl
extends BaseDAO
implements ActivitySortDAO {
    @Override
    public int insertBatch(List<ActivitySortDto> activitySortDtoList) throws TuiaMediaException {
        try {
            return this.getSqlSession().insert(this.getStamentNameSpace("insertBatch"), activitySortDtoList);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.insert data happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int update(ActivitySortDto activitySortDto) throws TuiaMediaException {
        try {
            return this.getSqlSession().update(this.getStamentNameSpace("update"), (Object)activitySortDto);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.update happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("selectByCondition"), (Object)reqActivitySort);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.selectByCondition happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        try {
            return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("selectByConditionAmount"), (Object)reqActivitySort);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.selectByConditionAmount happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int deleteAppAllActivity(Long activityAppId) throws TuiaMediaException {
        try {
            return this.getSqlSession().delete(this.getStamentNameSpace("deleteAppAllActivity"), (Object)activityAppId);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.deleteAppAllActivity happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int deleteActivity(Long activityAppId, Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("activityAppId", activityAppId);
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return this.getSqlSession().delete(this.getStamentNameSpace("deleteActivity"), map);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.deleteActivity happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public List<ActivitySortDto> getActivityForRecommend(Long appId) throws TuiaMediaException {
        try {
            return this.getSqlSession().selectList(this.getStamentNameSpace("getActivityForRecommend"), (Object)appId);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortDAO.getActivityForRecommend happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

